/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.mr.WritableValueWriter;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;

public class HiveWritableValueWriter
extends WritableValueWriter {
    public HiveWritableValueWriter() {
    }

    public HiveWritableValueWriter(boolean writeUnknownTypes) {
        super(writeUnknownTypes);
    }

    @Override
    public ValueWriter.Result write(Writable writable, Generator generator) {
        if (writable instanceof ByteWritable) {
            generator.writeNumber(((ByteWritable)writable).get());
        } else if (writable instanceof DoubleWritable) {
            generator.writeNumber(((DoubleWritable)writable).get());
        } else if (writable instanceof ShortWritable) {
            generator.writeNumber(((ShortWritable)writable).get());
        } else if (writable != null && "org.apache.hadoop.hive.serde2.io.HiveDecimalWritable".equals(writable.getClass().getName())) {
            generator.writeString(writable.toString());
        } else if (writable instanceof TimestampWritable) {
            long ts = ((TimestampWritable)writable).getTimestamp().getTime();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(ts);
            generator.writeString(DatatypeConverter.printDateTime((Calendar)cal));
        } else if (writable != null && "org.apache.hadoop.hive.serde2.io.DateWritable".equals(writable.getClass().getName())) {
            generator.writeString(DateWritableWriter.toES(writable));
        } else if (writable != null && "org.apache.hadoop.hive.serde2.io.HiveVarcharWritable".equals(writable.getClass().getName())) {
            generator.writeString(writable.toString());
        } else if (writable != null && "org.apache.hadoop.hive.serde2.io.HiveCharWritable".equals(writable.getClass().getName())) {
            generator.writeString(StringUtils.trim((String)writable.toString()));
        } else if (writable != null && "org.apache.hadoop.hive.serde2.io.TimestampWritableV2".equals(writable.getClass().getName())) {
            generator.writeString(TimestampV2Writer.toES(writable));
        } else if (writable != null && "org.apache.hadoop.hive.serde2.io.DateWritableV2".equals(writable.getClass().getName())) {
            generator.writeString(DateWritableWriterV2.toES(writable));
        } else {
            return super.write(writable, generator);
        }
        return ValueWriter.Result.SUCCESFUL();
    }

    private static abstract class DateWritableWriter {
        private DateWritableWriter() {
        }

        static String toES(Object dateWritable) {
            DateWritable dw = (DateWritable)dateWritable;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(dw.get().getTime());
            return DatatypeConverter.printDate((Calendar)cal);
        }
    }

    private static abstract class TimestampV2Writer {
        private TimestampV2Writer() {
        }

        static String toES(Object tsWriteableV2) {
            TimestampWritableV2 ts = (TimestampWritableV2)tsWriteableV2;
            long t = ts.getTimestamp().toEpochMilli();
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(t);
            return DatatypeConverter.printDateTime((Calendar)cal);
        }
    }

    private static abstract class DateWritableWriterV2 {
        private DateWritableWriterV2() {
        }

        static String toES(Object dateWritable) {
            DateWritableV2 dw = (DateWritableV2)dateWritable;
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(dw.get().toEpochMilli());
            return DatatypeConverter.printDate((Calendar)cal);
        }
    }
}

