"use strict";
/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Journey = void 0;
const step_1 = require("./step");
const monitor_1 = require("./monitor");
const helpers_1 = require("../helpers");
class Journey {
    name;
    id;
    tags;
    location;
    steps = [];
    #cb;
    #hooks = { before: [], after: [] };
    #monitor;
    skip = false;
    only = false;
    _startTime = 0;
    duration = -1;
    status = 'pending';
    error;
    constructor(options, cb, location) {
        this.name = options.name;
        this.id = options.id || options.name;
        this.tags = options.tags;
        this.#cb = cb;
        this.location = location;
        this._updateMonitor({});
    }
    _addStep(name, cb, location) {
        const step = new step_1.Step(name, this.steps.length + 1, cb, location);
        this.steps.push(step);
        return step;
    }
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _addStep for backwards compatibility
     */
    addStep(name, cb, location) {
        this._addStep(name, cb, location);
    }
    _addHook(type, cb) {
        this.#hooks[type].push(cb);
    }
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _addHook for backwards compatibility
     */
    addHook(type, cb) {
        this._addHook(type, cb);
    }
    _getHook(type) {
        return this.#hooks[type];
    }
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _getHook for backwards compatibility
     */
    getHook(type) {
        this._getHook(type);
    }
    _getMonitor() {
        return this.#monitor;
    }
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _getHook for backwards compatibility
     */
    get monitor() {
        return this._getMonitor();
    }
    _updateMonitor(config) {
        /**
         * Use defaults values from journey for monitor object (id, name and tags)
         */
        this.#monitor = new monitor_1.Monitor({
            name: this.name,
            id: this.id,
            type: 'browser',
            tags: this.tags ?? [],
            ...config,
        });
        this.#monitor.setSource(this.location);
        this.#monitor.setFilter({ match: this.name });
    }
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _updateMonitor for backwards compatibility
     */
    updateMonitor(config) {
        this._updateMonitor(config);
    }
    get cb() {
        return this.#cb;
    }
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias cb for backwards compatibility
     */
    get callback() {
        return this.#cb;
    }
    /**
     * Matches journeys based on the provided args. Proitize tags over match
     */
    _isMatch(matchPattern, tagsPattern) {
        return (0, helpers_1.isMatch)(this.tags, this.name, tagsPattern, matchPattern);
    }
    /**
     * @deprecated Since version 1.17.0. Please do not rely on the internal methods.
     * Alias _isMatch for backwards compatibility
     */
    isMatch(matchPattern, tagsPattern) {
        return this._isMatch(matchPattern, tagsPattern);
    }
}
exports.Journey = Journey;
//# sourceMappingURL=journey.js.map