/**
 * MIT License
 *
 * Copyright (c) 2020-present, Elastic NV
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */
import { Loader, CommonOptions, TransformOptions } from 'esbuild';
export declare function commonOptions(): CommonOptions;
/**
 * Transform the given code using esbuild and save the corresponding
 * map file in memory to be retrived later.
 */
export declare function transform(code: string, filename: string, options?: TransformOptions): import("esbuild").TransformResult<{
    sourcefile: string;
    loader: Loader;
    banner?: string;
    footer?: string;
    sourcemap?: boolean | "both" | "linked" | "inline" | "external";
    legalComments?: "none" | "linked" | "inline" | "external" | "eof";
    sourceRoot?: string;
    sourcesContent?: boolean;
    format?: import("esbuild").Format;
    globalName?: string;
    target?: string | string[];
    supported?: Record<string, boolean>;
    platform?: import("esbuild").Platform;
    mangleProps?: RegExp;
    reserveProps?: RegExp;
    mangleQuoted?: boolean;
    mangleCache?: Record<string, string | false>;
    drop?: import("esbuild").Drop[];
    dropLabels?: string[];
    minify?: boolean;
    minifyWhitespace?: boolean;
    minifyIdentifiers?: boolean;
    minifySyntax?: boolean;
    lineLimit?: number;
    charset?: import("esbuild").Charset;
    treeShaking?: boolean;
    ignoreAnnotations?: boolean;
    jsx?: "transform" | "preserve" | "automatic";
    jsxFactory?: string;
    jsxFragment?: string;
    jsxImportSource?: string;
    jsxDev?: boolean;
    jsxSideEffects?: boolean;
    define?: {
        [key: string]: string;
    };
    pure?: string[];
    keepNames?: boolean;
    color?: boolean;
    logLevel?: import("esbuild").LogLevel;
    logLimit?: number;
    logOverride?: Record<string, import("esbuild").LogLevel>;
    tsconfigRaw: string | import("esbuild").TsconfigRaw;
}>;
/**
 * Install the pirates hook to transform the code on the fly
 * for all of the imported files.
 */
export declare function installTransform(): () => void;
//# sourceMappingURL=transform.d.ts.map