/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Schema {
    public static void doSchemas(Connection conn, boolean tablesOnly) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT SCHEMANAME, SCHEMAID FROM SYS.SYSSCHEMAS");
        boolean firstTime = true;
        while (rs.next()) {
            String sName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            if (tablesOnly || dblook.isIgnorableSchema(sName) || sName.equals("\"APP\"")) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SchemasHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL("CREATE SCHEMA " + sName);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        stmt.close();
    }
}

