/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.SqlException;

class ClobLocatorOutputStream
extends OutputStream {
    private final ClientClob clob;
    private long currentPos;

    ClobLocatorOutputStream(ClientClob clob, long pos) throws SqlException {
        if (pos - 1L > clob.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.clob = clob;
        this.currentPos = pos;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] ba = new byte[]{(byte)b};
        this.writeBytes(ba);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        byte[] ba = b;
        if (off > 0 || len < b.length) {
            ba = new byte[len];
            System.arraycopy(b, off, ba, 0, len);
        }
        this.writeBytes(ba);
    }

    @Override
    public void flush() {
    }

    private void writeBytes(byte[] b) throws IOException {
        try {
            String clobStr = new String(b, "ISO-8859-1");
            this.clob.setStringX(this.currentPos, clobStr, 0, clobStr.length());
            this.currentPos += (long)b.length;
        }
        catch (SqlException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

