"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapEsHealthStatus2TransformHealthStatus = exports.isTransformHealthStatus = exports.addInternalBasePath = exports.addExternalBasePath = exports.TRANSFORM_STATE = exports.TRANSFORM_RULE_TYPE = exports.TRANSFORM_REACT_QUERY_KEYS = exports.TRANSFORM_NOTIFICATIONS_INDEX = exports.TRANSFORM_MODE = exports.TRANSFORM_HEALTH_STATUS = exports.TRANSFORM_HEALTH_RESULTS = exports.TRANSFORM_HEALTH_LABEL = exports.TRANSFORM_HEALTH_DESCRIPTION = exports.TRANSFORM_HEALTH_COLOR = exports.TRANSFORM_HEALTH_CHECK_NAMES = exports.TRANSFORM_FUNCTION = exports.TIME_FORMAT = exports.PROGRESS_REFRESH_INTERVAL_MS = exports.PLUGIN = exports.NODES_INFO_PRIVILEGES = exports.MINIMUM_REFRESH_INTERVAL_MS = exports.DEFAULT_TRANSFORM_SETTINGS_MAX_PAGE_SEARCH_SIZE = exports.DEFAULT_TRANSFORM_SETTINGS_DOCS_PER_SECOND = exports.DEFAULT_TRANSFORM_FREQUENCY = exports.DEFAULT_REFRESH_INTERVAL_MS = exports.DEFAULT_MAX_AUDIT_MESSAGE_SIZE = exports.DEFAULT_CONTINUOUS_MODE_DELAY = exports.APP_INDEX_PRIVILEGES = exports.APP_CLUSTER_PRIVILEGES = exports.ALL_TRANSFORMS_SELECTION = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_REFRESH_INTERVAL_MS = exports.DEFAULT_REFRESH_INTERVAL_MS = 30000;
const MINIMUM_REFRESH_INTERVAL_MS = exports.MINIMUM_REFRESH_INTERVAL_MS = 1000;
const PROGRESS_REFRESH_INTERVAL_MS = exports.PROGRESS_REFRESH_INTERVAL_MS = 2000;
const DEFAULT_MAX_AUDIT_MESSAGE_SIZE = exports.DEFAULT_MAX_AUDIT_MESSAGE_SIZE = 500;
const PLUGIN = exports.PLUGIN = {
  ID: 'transform',
  MINIMUM_LICENSE_REQUIRED: 'basic',
  getI18nName: () => {
    return _i18n.i18n.translate('xpack.transform.appName', {
      defaultMessage: 'Transforms'
    });
  }
};
const INTERNAL_API_BASE_PATH = '/internal/transform/';
const EXTERNAL_API_BASE_PATH = '/api/transform/';
const addInternalBasePath = uri => `${INTERNAL_API_BASE_PATH}${uri}`;
exports.addInternalBasePath = addInternalBasePath;
const addExternalBasePath = uri => `${EXTERNAL_API_BASE_PATH}${uri}`;
exports.addExternalBasePath = addExternalBasePath;
const TRANSFORM_REACT_QUERY_KEYS = exports.TRANSFORM_REACT_QUERY_KEYS = {
  DATA_SEARCH: 'transform.data_search',
  DATA_VIEW_EXISTS: 'transform.data_view_exists',
  GET_DATA_VIEW_IDS_WITH_TITLE: 'transform.get_data_view_ids_with_title',
  GET_DATA_VIEW_TITLES: 'transform.get_data_view_titles',
  GET_ES_INDICES: 'transform.get_es_indices',
  GET_ES_INGEST_PIPELINES: 'transform.get_es_ingest_pipelines',
  GET_HISTOGRAMS_FOR_FIELDS: 'transform.get_histograms_for_fields',
  GET_TRANSFORM: 'transform.get_transform',
  GET_TRANSFORM_NODES: 'transform.get_transform_nodes',
  GET_TRANSFORM_AUDIT_MESSAGES: 'transform.get_transform_audit_messages',
  GET_TRANSFORM_STATS: 'transform.get_transform_stats',
  GET_TRANSFORMS_STATS: 'transform.get_transforms_stats',
  GET_TRANSFORMS: 'transform.get_transforms',
  GET_TRANSFORMS_PREVIEW: 'transform.get_transforms_preview'
};

// In order to create a transform, the API requires the following privileges:
// - transform_admin (builtin)
//   - cluster privileges: manage_transform
//   - index privileges:
//     - indices: .transform-notifications-*, .data-frame-notifications-*, .transform-notifications-read
//     - privileges: view_index_metadata, read
// - transform_user (builtin)
//   - cluster privileges: monitor_transform
//   - index privileges:
//     - indices: .transform-notifications-*, .data-frame-notifications-*, .transform-notifications-read
//     - privileges: view_index_metadata, read
// - source index: read, view_index_metadata (can be applied to a pattern e.g. farequote-*)
// - dest index: index, create_index (can be applied to a pattern e.g. df-*)
//
// In the UI additional privileges are required:
// - kibana_admin (builtin)
// - dest index: monitor (applied to df-*)
// - cluster: monitor, read_pipeline
//
// Note that users with kibana_admin can see all Kibana data views and saved searches
// in the source selection modal when creating a transform, but the wizard will trigger
// error callouts when there are no sufficient privileges to read the actual source indices.

const APP_CLUSTER_PRIVILEGES = exports.APP_CLUSTER_PRIVILEGES = ['cluster:monitor/transform/get', 'cluster:monitor/transform/stats/get', 'cluster:admin/transform/delete', 'cluster:admin/transform/preview', 'cluster:admin/transform/put', 'cluster:admin/transform/reset', 'cluster:admin/transform/schedule_now', 'cluster:admin/transform/start', 'cluster:admin/transform/start_task', 'cluster:admin/transform/stop'];

// Minimum privileges required to return transform node count
const NODES_INFO_PRIVILEGES = exports.NODES_INFO_PRIVILEGES = ['cluster:monitor/transform/get'];
const APP_INDEX_PRIVILEGES = exports.APP_INDEX_PRIVILEGES = ['monitor'];

// reflects https://github.com/elastic/elasticsearch/blob/master/x-pack/plugin/core/src/main/java/org/elasticsearch/xpack/core/transform/transforms/TransformStats.java#L214
const TRANSFORM_STATE = exports.TRANSFORM_STATE = {
  ABORTING: 'aborting',
  FAILED: 'failed',
  INDEXING: 'indexing',
  STARTED: 'started',
  STOPPED: 'stopped',
  STOPPING: 'stopping',
  WAITING: 'waiting'
};
const TRANSFORM_HEALTH_STATUS = exports.TRANSFORM_HEALTH_STATUS = {
  green: 'green',
  yellow: 'yellow',
  red: 'red',
  unknown: 'unknown'
};
const isTransformHealthStatus = arg => typeof arg === 'string' && Object.keys(TRANSFORM_HEALTH_STATUS).includes(arg);
exports.isTransformHealthStatus = isTransformHealthStatus;
const mapEsHealthStatus2TransformHealthStatus = healthStatus => typeof healthStatus === 'string' && isTransformHealthStatus(healthStatus.toLowerCase()) ? healthStatus.toLowerCase() : TRANSFORM_HEALTH_STATUS.unknown;
exports.mapEsHealthStatus2TransformHealthStatus = mapEsHealthStatus2TransformHealthStatus;
const TRANSFORM_HEALTH_COLOR = exports.TRANSFORM_HEALTH_COLOR = {
  green: 'success',
  unknown: 'subdued',
  yellow: 'warning',
  red: 'danger'
};
const TRANSFORM_HEALTH_LABEL = exports.TRANSFORM_HEALTH_LABEL = {
  green: _i18n.i18n.translate('xpack.transform.transformHealth.greenLabel', {
    defaultMessage: 'Healthy'
  }),
  unknown: _i18n.i18n.translate('xpack.transform.transformHealth.unknownLabel', {
    defaultMessage: 'Unknown'
  }),
  yellow: _i18n.i18n.translate('xpack.transform.transformHealth.yellowLabel', {
    defaultMessage: 'Degraded'
  }),
  red: _i18n.i18n.translate('xpack.transform.transformHealth.redLabel', {
    defaultMessage: 'Unavailable'
  })
};
const TRANSFORM_HEALTH_DESCRIPTION = exports.TRANSFORM_HEALTH_DESCRIPTION = {
  green: _i18n.i18n.translate('xpack.transform.transformHealth.greenDescription', {
    defaultMessage: 'The transform is running as expected.'
  }),
  unknown: _i18n.i18n.translate('xpack.transform.transformHealth.unknownDescription', {
    defaultMessage: 'The health of the transform could not be determined.'
  }),
  yellow: _i18n.i18n.translate('xpack.transform.transformHealth.yellowDescription', {
    defaultMessage: 'The functionality of the transform is in a degraded state and may need remediation to avoid the health becoming red.'
  }),
  red: _i18n.i18n.translate('xpack.transform.transformHealth.redDescription', {
    defaultMessage: 'The transform is experiencing an outage or is unavailable for use.'
  })
};
const TRANSFORM_MODE = exports.TRANSFORM_MODE = {
  BATCH: 'batch',
  CONTINUOUS: 'continuous'
};
const TRANSFORM_FUNCTION = exports.TRANSFORM_FUNCTION = {
  PIVOT: 'pivot',
  LATEST: 'latest'
};
// Alerting

const TRANSFORM_RULE_TYPE = exports.TRANSFORM_RULE_TYPE = {
  TRANSFORM_HEALTH: 'transform_health'
};
const TRANSFORM_ALERT_NAMESPACE = _ruleDataUtils.ALERT_NAMESPACE;
const TRANSFORM_HEALTH_RESULTS = exports.TRANSFORM_HEALTH_RESULTS = `${TRANSFORM_ALERT_NAMESPACE}.results`;
const ALL_TRANSFORMS_SELECTION = exports.ALL_TRANSFORMS_SELECTION = '*';
const TRANSFORM_HEALTH_CHECK_NAMES = exports.TRANSFORM_HEALTH_CHECK_NAMES = {
  notStarted: {
    name: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.notStartedCheckName', {
      defaultMessage: 'Transform is not started'
    }),
    description: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.notStartedCheckDescription', {
      defaultMessage: 'Get alerts when the transform is not started or is not indexing data.'
    })
  },
  errorMessages: {
    name: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.errorMessagesCheckName', {
      defaultMessage: 'Errors in transform messages'
    }),
    description: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.errorMessagesCheckDescription', {
      defaultMessage: 'Get alerts if a transform contains errors in the transform messages.'
    })
  },
  healthCheck: {
    name: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.healthCheckName', {
      defaultMessage: 'Unhealthy transform'
    }),
    description: _i18n.i18n.translate('xpack.transform.alertTypes.transformHealth.healthCheckDescription', {
      defaultMessage: 'Get alerts if a transform health status is not green.'
    })
  }
};

// Transform API default values https://www.elastic.co/guide/en/elasticsearch/reference/current/put-transform.html
const DEFAULT_CONTINUOUS_MODE_DELAY = exports.DEFAULT_CONTINUOUS_MODE_DELAY = '60s';
const DEFAULT_TRANSFORM_FREQUENCY = exports.DEFAULT_TRANSFORM_FREQUENCY = '1m';
const DEFAULT_TRANSFORM_SETTINGS_DOCS_PER_SECOND = exports.DEFAULT_TRANSFORM_SETTINGS_DOCS_PER_SECOND = null;
const DEFAULT_TRANSFORM_SETTINGS_MAX_PAGE_SEARCH_SIZE = exports.DEFAULT_TRANSFORM_SETTINGS_MAX_PAGE_SEARCH_SIZE = 500;

// Used in the transform list's expanded row for the messages and issues table.
const TIME_FORMAT = exports.TIME_FORMAT = 'YYYY-MM-DD HH:mm:ss';
const TRANSFORM_NOTIFICATIONS_INDEX = exports.TRANSFORM_NOTIFICATIONS_INDEX = '.transform-notifications-read';