"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWithActiveSpan = createWithActiveSpan;
var _api = require("@opentelemetry/api");
var _with_active_span = require("./with_active_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Factory function that creates a version of {@link WithActiveSpan} with
 * default options.
 */
function createWithActiveSpan(defaultOptions, withActiveSpanWrapper) {
  return (...args) => {
    const name = args[0];
    const options = args.length === 2 ? {} : args[1];
    const ctx = args.length === 4 ? args[2] : _api.context.active();
    const cb = args.length === 2 ? args[1] : args.length === 3 ? args[2] : args[3];
    const nextOptions = {
      ...defaultOptions,
      ...options,
      attributes: {
        ...defaultOptions.attributes,
        ...options.attributes
      }
    };
    const allArgs = [name, nextOptions, ctx, cb];
    if (withActiveSpanWrapper) {
      return withActiveSpanWrapper(...allArgs);
    }
    return (0, _with_active_span.withActiveSpan)(...allArgs);
  };
}