"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setDiagLogger = setDiagLogger;
var _api = require("@opentelemetry/api");
var _util = require("util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helper to make it easier to configure OTel's {@link DiagLogger}.
 * @param logger {@link Logger}
 * @param logLevel The {@link LogLevelId} to set the Diag logger to.
 */
function setDiagLogger(logger, logLevel) {
  const diagLogger = {
    debug: (message, ...args) => {
      return logger.debug(() => (0, _util.format)(message, ...args));
    },
    error: (message, ...args) => {
      return logger.error(() => (0, _util.format)(message, ...args));
    },
    info: (message, ...args) => {
      return logger.info(() => (0, _util.format)(message, ...args));
    },
    verbose: (message, ...args) => {
      return logger.trace(() => (0, _util.format)(message, ...args));
    },
    warn: (message, ...args) => {
      return logger.warn(() => (0, _util.format)(message, ...args));
    }
  };
  let level;
  switch (logLevel) {
    case 'off':
      level = _api.DiagLogLevel.NONE;
      break;
    case 'fatal':
    case 'error':
      level = _api.DiagLogLevel.ERROR;
      break;
    case 'warn':
      level = _api.DiagLogLevel.WARN;
      break;
    default:
    case 'info':
      level = _api.DiagLogLevel.INFO;
      break;
    case 'debug':
      level = _api.DiagLogLevel.DEBUG;
      break;
    case 'trace':
      level = _api.DiagLogLevel.VERBOSE;
      break;
    case 'all':
      level = _api.DiagLogLevel.ALL;
      break;
  }
  _api.diag.setLogger(diagLogger, {
    suppressOverrideMessage: true,
    logLevel: level
  });
}