"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBuildShipperUrl = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Builds the URL for the V3 API.
 */
const createBuildShipperUrl = sendTo => urlOptions => {
  const {
    channelName
  } = urlOptions;
  const baseUrl = sendTo === 'production' ? 'https://telemetry.elastic.co' : 'https://telemetry-staging.elastic.co';
  return `${baseUrl}/v3/send/${channelName}`;
};
exports.createBuildShipperUrl = createBuildShipperUrl;