"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.taskSchemaV7 = exports.taskSchemaV6 = exports.taskSchemaV5 = exports.taskSchemaV4 = exports.taskSchemaV3 = exports.taskSchemaV2 = exports.taskSchemaV1 = exports.scheduleIntervalSchema = void 0;
exports.validateDuration = validateDuration;
var _configSchema = require("@kbn/config-schema");
var _intervals = require("../../lib/intervals");
var _rrule = require("./rrule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateDuration(duration) {
  if (!(0, _intervals.isInterval)(duration)) {
    return 'string is not a valid duration: ' + duration;
  }
}
const taskSchemaV1 = exports.taskSchemaV1 = _configSchema.schema.object({
  taskType: _configSchema.schema.string(),
  scheduledAt: _configSchema.schema.string(),
  startedAt: _configSchema.schema.nullable(_configSchema.schema.string()),
  retryAt: _configSchema.schema.nullable(_configSchema.schema.string()),
  runAt: _configSchema.schema.string(),
  schedule: _configSchema.schema.maybe(_configSchema.schema.object({
    interval: _configSchema.schema.string({
      validate: validateDuration
    })
  })),
  params: _configSchema.schema.string(),
  state: _configSchema.schema.string(),
  stateVersion: _configSchema.schema.maybe(_configSchema.schema.number()),
  traceparent: _configSchema.schema.string(),
  user: _configSchema.schema.maybe(_configSchema.schema.string()),
  scope: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  ownerId: _configSchema.schema.nullable(_configSchema.schema.string()),
  enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  timeoutOverride: _configSchema.schema.maybe(_configSchema.schema.string()),
  attempts: _configSchema.schema.number(),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal('idle'), _configSchema.schema.literal('claiming'), _configSchema.schema.literal('running'), _configSchema.schema.literal('failed'), _configSchema.schema.literal('unrecognized'), _configSchema.schema.literal('dead_letter')]),
  version: _configSchema.schema.maybe(_configSchema.schema.string())
});
const taskSchemaV2 = exports.taskSchemaV2 = taskSchemaV1.extends({
  partition: _configSchema.schema.maybe(_configSchema.schema.number())
});
const taskSchemaV3 = exports.taskSchemaV3 = taskSchemaV2.extends({
  priority: _configSchema.schema.maybe(_configSchema.schema.number())
});
const scheduleIntervalSchema = exports.scheduleIntervalSchema = _configSchema.schema.object({
  interval: _configSchema.schema.string({
    validate: validateDuration
  })
});
const taskSchemaV4 = exports.taskSchemaV4 = taskSchemaV3.extends({
  apiKey: _configSchema.schema.maybe(_configSchema.schema.string()),
  userScope: _configSchema.schema.maybe(_configSchema.schema.object({
    apiKeyId: _configSchema.schema.string(),
    spaceId: _configSchema.schema.string(),
    apiKeyCreatedByUser: _configSchema.schema.boolean()
  }))
});
const taskSchemaV5 = exports.taskSchemaV5 = taskSchemaV4.extends({
  schedule: _configSchema.schema.maybe(_configSchema.schema.oneOf([scheduleIntervalSchema, _rrule.scheduleRruleSchemaV1]))
});
const taskSchemaV6 = exports.taskSchemaV6 = taskSchemaV5.extends({
  schedule: _configSchema.schema.maybe(_configSchema.schema.oneOf([scheduleIntervalSchema, _rrule.scheduleRruleSchemaV2]))
});
const taskSchemaV7 = exports.taskSchemaV7 = taskSchemaV6.extends({
  schedule: _configSchema.schema.maybe(_configSchema.schema.oneOf([scheduleIntervalSchema, _rrule.scheduleRruleSchemaV3]))
});