"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleRruleSchema = exports.rruleSchedule = void 0;
var _configSchema = require("@kbn/config-schema");
var _rrule = require("@kbn/rrule");
var _v = require("./v1");
var _v2 = require("./v2");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rruleMonthly = _v2.rruleMonthly;
const rruleWeekly = _v2.rruleWeekly;
const rruleDaily = _v2.rruleDaily;
const rruleHourly = _v2.rruleCommon.extends({
  freq: _configSchema.schema.literal(_rrule.Frequency.HOURLY),
  byminute: _v.byminute,
  byhour: _configSchema.schema.never(),
  byweekday: _configSchema.schema.never(),
  bymonthday: _configSchema.schema.never()
});
const rruleSchedule = exports.rruleSchedule = _configSchema.schema.oneOf([rruleMonthly, rruleWeekly, rruleDaily, rruleHourly]);
const scheduleRruleSchema = exports.scheduleRruleSchema = _configSchema.schema.object({
  rrule: rruleSchedule
});