"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsRoute = metricsRoute;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QuerySchema = _configSchema.schema.object({
  reset: _configSchema.schema.boolean({
    defaultValue: true
  })
});
function metricsRoute(params) {
  const {
    router,
    metrics$,
    resetMetrics$,
    taskManagerId
  } = params;
  let lastMetrics = null;
  metrics$.subscribe(metrics => {
    lastMetrics = {
      process_uuid: taskManagerId,
      timestamp: new Date().toISOString(),
      ...metrics
    };
  });
  router.get({
    path: `/api/task_manager/metrics`,
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization. It can be accessed with JWT credentials.'
      }
    },
    options: {
      access: 'public',
      // The `security:acceptJWT` tag allows route to be accessed with JWT credentials. It points to
      // ROUTE_TAG_ACCEPT_JWT from '@kbn/security-plugin/server' that cannot be imported here directly.
      tags: ['security:acceptJWT']
    },
    // Uncomment when we determine that we can restrict API usage to Global admins based on telemetry
    // security: {
    //   authz: {
    //     requiredPrivileges: ['taskManager'],
    //   },
    // },
    validate: {
      query: QuerySchema
    }
  }, async function (_, req, res) {
    if (req.query.reset) {
      resetMetrics$.next(true);
    }
    return res.ok({
      body: lastMetrics ? lastMetrics : {
        process_uuid: taskManagerId,
        timestamp: new Date().toISOString(),
        metrics: {}
      }
    });
  });
}