"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkPublicLocationsPermissions = exports.addSyntheticsProjectMonitorRoute = exports.REQUEST_TOO_LARGE_LIGHTWEIGHT = exports.REQUEST_TOO_LARGE = exports.ELASTIC_MANAGED_LOCATIONS_DISABLED = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _pMap = _interopRequireDefault(require("p-map"));
var _common = require("@kbn/spaces-plugin/common");
var _constants = require("@kbn/spaces-plugin/common/constants");
var _saved_objects = require("../../../../common/types/saved_objects");
var _validate_space_id = require("../services/validate_space_id");
var _constants2 = require("../../../../common/constants");
var _project_monitor_formatter = require("../../../synthetics_service/project_monitor/project_monitor_formatter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PAYLOAD_SIZE = 1048576 * 100; // 50MiB

const addSyntheticsProjectMonitorRoute = () => ({
  method: 'PUT',
  path: _constants2.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS_PROJECT_UPDATE,
  validate: {
    query: _configSchema.schema.object({
      // primarily used for testing purposes, to specify the type of saved object
      savedObjectType: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_saved_objects.syntheticsMonitorSavedObjectType), _configSchema.schema.literal(_saved_objects.legacySyntheticsMonitorTypeSingle)], {
        defaultValue: _saved_objects.syntheticsMonitorSavedObjectType
      }))
    }),
    params: _configSchema.schema.object({
      projectName: _configSchema.schema.string()
    }),
    body: _configSchema.schema.object({
      monitors: _configSchema.schema.arrayOf(_configSchema.schema.any())
    })
  },
  options: {
    body: {
      maxBytes: MAX_PAYLOAD_SIZE
    }
  },
  handler: async routeContext => {
    var _request$body;
    const {
      request,
      response,
      server
    } = routeContext;
    const {
      projectName
    } = request.params;
    const decodedProjectName = decodeURI(projectName);
    const monitors = ((_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.monitors) || [];
    const lightWeightMonitors = monitors.filter(monitor => monitor.type !== 'browser');
    const browserMonitors = monitors.filter(monitor => monitor.type === 'browser');
    if (browserMonitors.length > 250) {
      return response.badRequest({
        body: {
          message: REQUEST_TOO_LARGE
        }
      });
    }
    if (lightWeightMonitors.length > 1500) {
      return response.badRequest({
        body: {
          message: REQUEST_TOO_LARGE_LIGHTWEIGHT
        }
      });
    }
    try {
      const [spaceId, permissionError] = await Promise.all([validMultiSpacePrivileges(routeContext, monitors), checkPublicLocationsPermissions(routeContext, monitors)]);
      if (permissionError) {
        return response.forbidden({
          body: {
            message: permissionError
          }
        });
      }
      const pushMonitorFormatter = new _project_monitor_formatter.ProjectMonitorFormatter({
        routeContext,
        projectId: decodedProjectName,
        spaceId,
        monitors
      });
      await pushMonitorFormatter.configureAllProjectMonitors();
      return {
        createdMonitors: pushMonitorFormatter.createdMonitors,
        updatedMonitors: pushMonitorFormatter.updatedMonitors,
        failedMonitors: pushMonitorFormatter.failedMonitors
      };
    } catch (error) {
      var _error$output;
      if (((_error$output = error.output) === null || _error$output === void 0 ? void 0 : _error$output.statusCode) === 404) {
        return response.notFound({
          body: {
            message: `Kibana space '${routeContext.spaceId}' does not exist`
          }
        });
      }
      server.logger.error(`Error adding monitors to project ${decodedProjectName}`, {
        error
      });
      throw error;
    }
  }
});
exports.addSyntheticsProjectMonitorRoute = addSyntheticsProjectMonitorRoute;
const validProjectMultiSpace = async (routeContext, monitors) => {
  var _server$spaces;
  const {
    response,
    server
  } = routeContext;
  const spaceId = await (0, _validate_space_id.validateSpaceId)(routeContext);
  const spacesList = new Set(monitors.map(monitor => {
    var _monitor$spaces;
    return (_monitor$spaces = monitor.spaces) !== null && _monitor$spaces !== void 0 ? _monitor$spaces : [];
  }).flat().filter(sp => sp !== _constants.ALL_SPACES_ID));
  if (spacesList.size === 1 && spacesList.has(_common.DEFAULT_SPACE_ID) || spacesList.size === 0) {
    return spaceId;
  }
  const spacesClient = (_server$spaces = server.spaces) === null || _server$spaces === void 0 ? void 0 : _server$spaces.spacesService.createSpacesClient(routeContext.request);
  if (spacesClient) {
    try {
      await (0, _pMap.default)(spacesList, async space => {
        await spacesClient.get(space);
      }, {
        concurrency: 5,
        stopOnError: true
      });
    } catch (error) {
      throw response.notFound({
        body: {
          message: `Kibana space does not exist, ${error}`
        }
      });
    }
  }
  for (const monitor of monitors) {
    var _monitor$spaces2;
    if ((_monitor$spaces2 = monitor.spaces) !== null && _monitor$spaces2 !== void 0 && _monitor$spaces2.length && !monitor.spaces.includes(spaceId)) {
      throw response.badRequest({
        body: {
          message: _i18n.i18n.translate('xpack.synthetics.server.project.addMonitor.multiSpaceValidation', {
            defaultMessage: 'Monitor {monitor} does not include spaceId {spaceId} in its spaces.',
            values: {
              monitor: monitor.name,
              spaceId
            }
          })
        }
      });
    }
  }
  return spaceId;
};
const validMultiSpacePrivileges = async (routeContext, monitors) => {
  const {
    spaceId,
    request,
    response,
    server
  } = routeContext;
  const spacesList = monitors.flatMap(monitor => {
    var _monitor$spaces3;
    return (_monitor$spaces3 = monitor.spaces) !== null && _monitor$spaces3 !== void 0 ? _monitor$spaces3 : [];
  });
  if (spacesList.length === 0 || spacesList.length === 1 && spacesList[0] === spaceId) {
    // If there are no spaces or only the current space, no need to check privileges
    return validProjectMultiSpace(routeContext, monitors);
  }
  const checkSavedObjectsPrivileges = server.security.authz.checkSavedObjectsPrivilegesWithRequest(request);
  const {
    hasAllRequested
  } = await checkSavedObjectsPrivileges('saved_object:synthetics-monitor/bulk_update', spacesList);
  if (!hasAllRequested) {
    throw response.forbidden({
      body: {
        message: _i18n.i18n.translate('xpack.synthetics.addMonitor.forbidden', {
          defaultMessage: 'You do not have sufficient permissions to update monitors in all required spaces.'
        })
      }
    });
  }
  return validProjectMultiSpace(routeContext, monitors);
};
const checkPublicLocationsPermissions = async ({
  server,
  request
}, projectMonitors) => {
  var _Boolean, _server$coreStart;
  const hasPublicLocations = projectMonitors.some(({
    locations
  }) => (locations !== null && locations !== void 0 ? locations : []).length > 0);
  if (!hasPublicLocations) {
    return;
  }
  const elasticManagedLocationsEnabled = (_Boolean = Boolean((await ((_server$coreStart = server.coreStart) === null || _server$coreStart === void 0 ? void 0 : _server$coreStart.capabilities.resolveCapabilities(request, {
    capabilityPath: 'uptime.*'
  }))).uptime.elasticManagedLocationsEnabled)) !== null && _Boolean !== void 0 ? _Boolean : true;
  if (!elasticManagedLocationsEnabled) {
    return ELASTIC_MANAGED_LOCATIONS_DISABLED;
  }
};
exports.checkPublicLocationsPermissions = checkPublicLocationsPermissions;
const ELASTIC_MANAGED_LOCATIONS_DISABLED = exports.ELASTIC_MANAGED_LOCATIONS_DISABLED = _i18n.i18n.translate('xpack.synthetics.noAccess.publicLocations', {
  defaultMessage: "You don't have permission to use Elastic managed global locations. Please contact your Kibana administrator."
});
const REQUEST_TOO_LARGE = exports.REQUEST_TOO_LARGE = _i18n.i18n.translate('xpack.synthetics.server.project.delete.request', {
  defaultMessage: 'Request payload is too large. Please send a max of 250 browser monitors per request.'
});
const REQUEST_TOO_LARGE_LIGHTWEIGHT = exports.REQUEST_TOO_LARGE_LIGHTWEIGHT = _i18n.i18n.translate('xpack.synthetics.server.project.delete.request.lightweight', {
  defaultMessage: 'Request payload is too large. Please send a max of 1500 lightweight monitors per request.'
});