"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsEsClient = void 0;
exports.createEsParams = createEsParams;
exports.isTestUser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/inspector-plugin/common");
var _common2 = require("@kbn/observability-plugin/common");
var _common3 = require("@kbn/observability-shared-plugin/common");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SyntheticsEsClient {
  constructor(savedObjectsClient, esClient, options) {
    (0, _defineProperty2.default)(this, "isDev", void 0);
    (0, _defineProperty2.default)(this, "request", void 0);
    (0, _defineProperty2.default)(this, "baseESClient", void 0);
    (0, _defineProperty2.default)(this, "isInspectorEnabled", void 0);
    (0, _defineProperty2.default)(this, "inspectableEsQueries", []);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    const {
      isDev = false,
      uiSettings,
      request
    } = options !== null && options !== void 0 ? options : {};
    this.uiSettings = uiSettings;
    this.baseESClient = esClient;
    this.savedObjectsClient = savedObjectsClient;
    this.request = request;
    this.isDev = isDev;
    this.inspectableEsQueries = [];
    this.getInspectEnabled().catch(() => {});
  }
  async search(params, operationName) {
    let res;
    let esError;
    const esParams = {
      index: _constants.SYNTHETICS_INDEX_PATTERN,
      ignore_unavailable: true,
      ...params
    };
    const startTimeNow = Date.now();
    let esRequestStatus = _common.RequestStatus.PENDING;
    const isInspectorEnabled = await this.getInspectEnabled();
    try {
      res = await this.baseESClient.search(esParams, {
        meta: true,
        context: {
          loggingOptions: getElasticsearchRequestLoggingOptions()
        }
      });
      esRequestStatus = _common.RequestStatus.OK;
    } catch (e) {
      esError = e;
      esRequestStatus = _common.RequestStatus.ERROR;
    }
    if ((isInspectorEnabled || this.isDev) && this.request) {
      var _res;
      this.inspectableEsQueries.push((0, _common3.getInspectResponse)({
        esError,
        esRequestParams: esParams,
        esRequestStatus,
        esResponse: (_res = res) === null || _res === void 0 ? void 0 : _res.body,
        kibanaRequest: this.request,
        operationName: operationName !== null && operationName !== void 0 ? operationName : '',
        startTime: startTimeNow
      }));
    }
    if (esError) {
      throw esError;
    }
    return res;
  }
  async msearch(requests, operationName) {
    var _ref, _res3, _res3$body;
    const searches = [];
    for (const request of requests) {
      searches.push({
        index: _constants.SYNTHETICS_INDEX_PATTERN,
        ignore_unavailable: true
      });
      searches.push(request);
    }
    const startTimeNow = Date.now();
    let res;
    let esError;
    try {
      res = await this.baseESClient.msearch({
        searches
      }, {
        meta: true
      });
    } catch (e) {
      esError = e;
    }
    const isInspectorEnabled = await this.getInspectEnabled();
    if (isInspectorEnabled && this.request) {
      requests.forEach((request, index) => {
        var _res2;
        this.inspectableEsQueries.push((0, _common3.getInspectResponse)({
          esError,
          esRequestParams: {
            index: _constants.SYNTHETICS_INDEX_PATTERN,
            ignore_unavailable: true,
            ...request
          },
          esRequestStatus: _common.RequestStatus.OK,
          esResponse: (_res2 = res) === null || _res2 === void 0 ? void 0 : _res2.body.responses[index],
          kibanaRequest: this.request,
          operationName: operationName !== null && operationName !== void 0 ? operationName : '',
          startTime: startTimeNow
        }));
      });
    }
    return {
      responses: (_ref = (_res3 = res) === null || _res3 === void 0 ? void 0 : (_res3$body = _res3.body) === null || _res3$body === void 0 ? void 0 : _res3$body.responses) !== null && _ref !== void 0 ? _ref : []
    };
  }
  async count(params) {
    let res;
    let esError;
    const esParams = {
      index: _constants.SYNTHETICS_INDEX_PATTERN,
      ignore_unavailable: true,
      ...params
    };
    try {
      res = await this.baseESClient.count(esParams, {
        meta: true,
        context: {
          loggingOptions: getElasticsearchRequestLoggingOptions()
        }
      });
    } catch (e) {
      esError = e;
    }
    if (esError) {
      throw esError;
    }
    return {
      result: res,
      indices: _constants.SYNTHETICS_INDEX_PATTERN
    };
  }
  getSavedObjectsClient() {
    return this.savedObjectsClient;
  }
  async getInspectData(path) {
    const isInspectorEnabled = await this.getInspectEnabled();
    const showInspectData = (isInspectorEnabled || this.isDev) && path !== _constants.SYNTHETICS_API_URLS.DYNAMIC_SETTINGS;
    if (showInspectData && this.inspectableEsQueries.length > 0) {
      return {
        _inspect: this.inspectableEsQueries
      };
    }
    return {};
  }
  async getInspectEnabled() {
    if (!this.uiSettings) {
      return false;
    }
    if (this.isInspectorEnabled === undefined) {
      this.isInspectorEnabled = this.uiSettings.client.get(_common2.enableInspectEsQueries);
    }
    return this.isInspectorEnabled;
  }
}
exports.SyntheticsEsClient = SyntheticsEsClient;
function createEsParams(params) {
  return params;
}
const isTestUser = server => {
  var _server$config$servic;
  return ((_server$config$servic = server.config.service) === null || _server$config$servic === void 0 ? void 0 : _server$config$servic.username) === 'localKibanaIntegrationTestsUser';
};
exports.isTestUser = isTestUser;
function getElasticsearchRequestLoggingOptions() {
  return {
    loggerName: 'synthetics'
  };
}