"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _Either = require("fp-ts/Either");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/spaces-plugin/common");
var _kibana_service = require("../kibana_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ApiService {
  get http() {
    return this._http;
  }
  set http(httpSetup) {
    this._http = httpSetup;
  }
  get addInspectorRequest() {
    return this._addInspectorRequest;
  }
  set addInspectorRequest(addInspectorRequest) {
    this._addInspectorRequest = addInspectorRequest;
  }
  constructor() {
    (0, _defineProperty2.default)(this, "_http", void 0);
    (0, _defineProperty2.default)(this, "_addInspectorRequest", void 0);
  }
  static getInstance() {
    if (!ApiService.instance) {
      ApiService.instance = new ApiService();
    }
    return ApiService.instance;
  }
  parseResponse(response, apiUrl, decodeType) {
    if (decodeType) {
      const decoded = decodeType.decode(response);
      if ((0, _Either.isRight)(decoded)) {
        return decoded.right;
      } else {
        // This was changed from using template literals to using %s string
        // interpolation, but the previous version included the apiUrl value
        // twice. To ensure the log output doesn't change, this continues.
        //
        // eslint-disable-next-line no-console
        console.error('API %s is not returning expected response, %s for response', apiUrl, (0, _securitysolutionIoTsUtils.formatErrors)(decoded.left).toString(), apiUrl, response);
      }
    }
    return response;
  }
  parseApiUrl(apiUrl, spaceId) {
    if (spaceId && spaceId !== 'default' && spaceId !== '*') {
      const basePath = _kibana_service.kibanaService.coreSetup.http.basePath;
      return (0, _common.addSpaceIdToPath)(basePath.serverBasePath, spaceId, apiUrl);
    }
    return apiUrl;
  }
  async get(apiUrl, params = {}, decodeType, options) {
    var _this$addInspectorReq;
    const {
      version,
      spaceId,
      ...queryParams
    } = params;
    const response = await this._http.fetch({
      path: this.parseApiUrl(apiUrl, spaceId),
      query: queryParams,
      version,
      ...(options !== null && options !== void 0 ? options : {}),
      ...(spaceId ? {
        prependBasePath: false
      } : {})
    });
    (_this$addInspectorReq = this.addInspectorRequest) === null || _this$addInspectorReq === void 0 ? void 0 : _this$addInspectorReq.call(this, {
      data: response,
      status: _public.FETCH_STATUS.SUCCESS,
      loading: false
    });
    return this.parseResponse(response, apiUrl, decodeType);
  }
  async post(apiUrl, data, decodeType, params = {}) {
    var _this$addInspectorReq2;
    const {
      version,
      spaceId,
      ...queryParams
    } = params;
    const response = await this._http.post(this.parseApiUrl(apiUrl, spaceId), {
      method: 'POST',
      body: JSON.stringify(data),
      query: queryParams,
      version,
      ...(spaceId ? {
        prependBasePath: false
      } : {})
    });
    (_this$addInspectorReq2 = this.addInspectorRequest) === null || _this$addInspectorReq2 === void 0 ? void 0 : _this$addInspectorReq2.call(this, {
      data: response,
      status: _public.FETCH_STATUS.SUCCESS,
      loading: false
    });
    return this.parseResponse(response, apiUrl, decodeType);
  }
  async put(apiUrl, data, decodeType, params = {}, options) {
    const {
      version,
      spaceId,
      ...queryParams
    } = params;
    const response = await this._http.put(this.parseApiUrl(apiUrl, spaceId), {
      method: 'PUT',
      body: JSON.stringify(data),
      query: queryParams,
      version,
      ...(options !== null && options !== void 0 ? options : {}),
      ...(spaceId ? {
        prependBasePath: false
      } : {})
    });
    return this.parseResponse(response, apiUrl, decodeType);
  }
  async delete(apiUrl, params = {}, data, options) {
    const {
      version,
      spaceId,
      ...queryParams
    } = params;
    const response = await this._http.delete({
      path: this.parseApiUrl(apiUrl, spaceId),
      query: queryParams,
      body: JSON.stringify(data),
      version,
      ...(options !== null && options !== void 0 ? options : {}),
      ...(spaceId ? {
        prependBasePath: false
      } : {})
    });
    if (response instanceof Error) {
      throw response;
    }
    return response;
  }
}
(0, _defineProperty2.default)(ApiService, "instance", void 0);
const apiService = exports.apiService = ApiService.getInstance();