"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsPrivileges = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _overview_status = require("../state/overview_status");
var _use_capabilities = require("../../../hooks/use_capabilities");
var _constants = require("../../../../common/constants");
var _contexts = require("../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/hooks/use_synthetics_priviliges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useSyntheticsPrivileges = () => {
  var _error$body, _error$body2;
  const {
    canRead: canReadSyntheticsIndex,
    loading: isCanReadLoading
  } = (0, _use_capabilities.useCanReadSyntheticsIndex)();
  const {
    error
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  if (!isCanReadLoading && !canReadSyntheticsIndex) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: 'calc(100vh - 150px)'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(Unprivileged, {
      unprivilegedIndices: [_constants.SYNTHETICS_INDEX_PATTERN],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    })));
  }
  if (error !== null && error !== void 0 && (_error$body = error.body) !== null && _error$body !== void 0 && _error$body.message && [_constants.LICENSE_NOT_ACTIVE_ERROR, _constants.LICENSE_MISSING_ERROR, _constants.LICENSE_NOT_SUPPORTED_ERROR].includes(error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      style: {
        height: 'calc(100vh - 150px)'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(LicenseExpired, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    })));
  }
};
exports.useSyntheticsPrivileges = useSyntheticsPrivileges;
const Unprivileged = ({
  unprivilegedIndices
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": "syntheticsUnprivileged",
  color: "plain",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoObservability",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.noFindingsStates.unprivileged.unprivilegedTitle",
    defaultMessage: "Privileges required",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.noFindingsStates.unprivileged.unprivilegedDescription",
    defaultMessage: "To view Synthetics monitors data, you must update privileges. For more information, contact your Kibana administrator.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })),
  footer: /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react2.css)`
          text-align: initial;
        `,
    children: _i18n.i18n.translate('xpack.synthetics.noFindingsStates.unprivileged.unprivilegedFooterMarkdown', {
      defaultMessage: 'Required Elasticsearch index privilege `read` for the following indices:'
    }) + unprivilegedIndices.map(idx => `\n- \`${idx}\``),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 3
  }
});
const LicenseExpired = () => {
  var _useKibana$services$l;
  const licenseManagementEnabled = (_useKibana$services$l = (0, _public.useKibana)().services.licenseManagement) === null || _useKibana$services$l === void 0 ? void 0 : _useKibana$services$l.enabled;
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "syntheticsUnprivileged",
    iconType: "warning",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.license.invalidLicenseTitle",
      defaultMessage: "Invalid License",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.license.invalidLicenseDescription",
      defaultMessage: "The Synthetics UI is not available because your current license has expired or is no longer valid.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "aria-label": _i18n.i18n.translate('xpack.synthetics.invalidLicense.manageYourLicenseButton', {
        defaultMessage: 'Navigate to license management'
      }),
      "data-test-subj": "apmInvalidLicenseNotificationManageYourLicenseButton",
      isDisabled: !licenseManagementEnabled,
      href: basePath + '/app/management/stack/license_management',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.synthetics.invalidLicense.licenseManagementLink', {
      defaultMessage: 'Manage your license'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  });
};