"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsPageReady = void 0;
var _reactRedux = require("react-redux");
var _ebtTools = require("@kbn/ebt-tools");
var _overview_status = require("../state/overview_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyntheticsPageReady = props => {
  const {
    loaded,
    isInitialLoad,
    loading: isLoadingOverviewStatus
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _ebtTools.usePageReady)({
    isReady: loaded,
    customInitialLoad: {
      value: isInitialLoad,
      onInitialLoadReported: () => {
        dispatch((0, _overview_status.initialLoadReported)());
      }
    },
    // This will collect the metric even when we are periodically refreshing the data in the background
    // and not only when the user decides to refresh the data, the action is the same
    isRefreshing: loaded && isLoadingOverviewStatus,
    meta: props === null || props === void 0 ? void 0 : props.meta
  });
};
exports.useSyntheticsPageReady = useSyntheticsPageReady;