"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingRedirects = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/simple/ping_list/ping_redirects.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ListGroup = (0, _styledComponents.default)(_eui.EuiListGroup)`
  &&& {
    a {
      padding-left: 0;
    }
  }
`;
const PingRedirects = ({
  monitorStatus,
  showTitle
}) => {
  var _monitorStatus$url, _monitorStatus$http, _monitorStatus$http$r, _list$length;
  const monitorUrl = monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$url = monitorStatus.url) === null || _monitorStatus$url === void 0 ? void 0 : _monitorStatus$url.full;
  const list = monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$http = monitorStatus.http) === null || _monitorStatus$http === void 0 ? void 0 : (_monitorStatus$http$r = _monitorStatus$http.response) === null || _monitorStatus$http$r === void 0 ? void 0 : _monitorStatus$http$r.redirects;
  const listOfRedirects = [{
    label: monitorUrl,
    href: monitorUrl,
    iconType: 'globe',
    size: 's',
    target: '_blank',
    extraAction: {
      color: 'text',
      iconType: 'popout',
      iconSize: 's',
      alwaysShow: true,
      'aria-label': _i18n.i18n.translate('xpack.synthetics.monitorList.redirects.openWindow', {
        defaultMessage: 'Link will open in new window.'
      })
    }
  }];
  (list !== null && list !== void 0 ? list : []).forEach(url => {
    listOfRedirects.push({
      label: url,
      href: url,
      iconType: 'sortDown',
      size: 's',
      target: '_blank',
      extraAction: {
        color: 'text',
        iconType: 'popout',
        iconSize: 's',
        'aria-label': _i18n.i18n.translate('xpack.synthetics.monitorList.redirects.openWindow', {
          defaultMessage: 'Link will open in new window.'
        }),
        alwaysShow: true
      }
    });
  });
  const Panel = showTitle ? _eui.EuiPanel : 'div';
  return list ? /*#__PURE__*/_react.default.createElement(Panel, {
    "data-test-subj": "uptimeMonitorPingListRedirectInfo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, showTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorList.redirects.title', {
    defaultMessage: 'Redirects'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.synthetics.monitorList.redirects.description', {
    defaultMessage: 'Heartbeat followed {number} redirects while executing ping.',
    values: {
      number: (_list$length = list === null || list === void 0 ? void 0 : list.length) !== null && _list$length !== void 0 ? _list$length : 0
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ListGroup, {
    gutterSize: 'none',
    listItems: listOfRedirects,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  })) : null;
};
exports.PingRedirects = PingRedirects;