"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallSidebarItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _middle_truncated_text = require("./middle_truncated_text");
var _styles = require("./styles");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_sidebar_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WaterfallSidebarItem = exports.WaterfallSidebarItem = /*#__PURE__*/_react.default.memo(function WaterfallSidebarItem({
  item,
  highestIndex,
  renderFilterScreenReaderText,
  onClick
}) {
  const [buttonRef, setButtonRef] = (0, _react.useState)();
  const {
    status,
    offsetIndex,
    index,
    isHighlighted,
    url
  } = item;
  const handleSidebarClick = (0, _react.useMemo)(() => {
    if (onClick) {
      return () => onClick({
        buttonRef,
        networkItemIndex: index
      });
    }
  }, [buttonRef, index, onClick]);
  const setRef = (0, _react.useCallback)(ref => setButtonRef(ref), [setButtonRef]);
  const isErrorStatusCode = statusCode => {
    const is400 = statusCode >= 400 && statusCode <= 499;
    const is500 = statusCode >= 500 && statusCode <= 599;
    const isSpecific300 = statusCode === 301 || statusCode === 307 || statusCode === 308;
    return is400 || is500 || isSpecific300;
  };
  const ariaLabel = `${isHighlighted && renderFilterScreenReaderText ? `${_translations.SIDEBAR_FILTER_MATCHES_SCREENREADER_LABEL} ` : ''}${url}`;
  return /*#__PURE__*/_react.default.createElement(_styles.SideBarItemHighlighter, {
    css: {
      opacity: isHighlighted ? '1' : '0.4'
    },
    "data-test-subj": isHighlighted ? 'sideBarHighlightedItem' : 'sideBarDimmedItem',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, !status || !isErrorStatusCode(status) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_middle_truncated_text.MiddleTruncatedText, {
    index: offsetIndex,
    url: url,
    ariaLabel: ariaLabel,
    onClick: handleSidebarClick,
    setButtonRef: setRef,
    highestIndex: highestIndex,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_middle_truncated_text.MiddleTruncatedText, {
    index: offsetIndex,
    url: url,
    ariaLabel: ariaLabel,
    onClick: handleSidebarClick,
    setButtonRef: setRef,
    highestIndex: highestIndex,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, status))));
});