"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallLegendItem = WaterfallLegendItem;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_header/waterfall_legend_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function WaterfallLegendItem({
  id,
  color,
  label,
  boxSize = 12,
  isClickable = false,
  isActive = false,
  onClick
}) {
  const [isHovered, setIsHovered] = (0, _react.useState)(false);
  const onMouseEvent = (0, _react.useCallback)(evt => {
    setIsHovered((evt === null || evt === void 0 ? void 0 : evt.type) === 'mouseenter');
  }, []);
  const isBoxFilled = !isClickable || isActive || isHovered;
  const title = isClickable ? CLICK_FILTER_LABEL : undefined;
  const ariaLabel = `${label}${isClickable ? ` - ${title}` : ''}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: StyledLegendItem,
    role: isClickable ? 'checkbox' : 'listitem',
    title: title,
    "aria-label": ariaLabel,
    "aria-checked": isClickable ? isActive : undefined,
    css: {
      height: 16,
      cursor: isClickable ? 'pointer' : undefined
    },
    alignItems: "center",
    gutterSize: "s",
    onMouseEnter: onMouseEvent,
    onMouseLeave: onMouseEvent,
    onClick: () => {
      onClick === null || onClick === void 0 ? void 0 : onClick(id);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: color,
    size: "m",
    type: isBoxFilled ? 'stopFilled' : 'stopSlash',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, label));
}
const StyledLegendItem = _common.euiStyled.div`
  flex-grow: 0;
  flex-shrink: 0;
  &:active {
    ${({
  role
}) => role === 'checkbox' ? 'text-decoration: underline;' : ''}
  }
`;
const CLICK_FILTER_LABEL = _i18n.i18n.translate('xpack.synthetics.waterfall.applyFilters.message', {
  defaultMessage: 'Click to add or remove filter'
});