"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepRunDate = exports.StepPageNavigation = exports.PREVIOUS_CHECK_BUTTON_TEXT = exports.NEXT_CHECK_BUTTON_TEXT = exports.CURRENT_CHECK_ARIA_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _use_selected_location = require("../monitor_details/hooks/use_selected_location");
var _contexts = require("../../contexts");
var _test_details_link = require("../common/links/test_details_link");
var _use_step_detail_page = require("./hooks/use_step_detail_page");
var _use_journey_steps = require("../monitor_details/hooks/use_journey_steps");
var _use_date_format = require("../../../../hooks/use_date_format");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_page_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepRunDate = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: ERROR_DURATION,
      description: /*#__PURE__*/_react.default.createElement(StepPageNavigation, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 57
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
};
exports.StepRunDate = StepRunDate;
const ERROR_DURATION = _i18n.i18n.translate('xpack.synthetics.testDetails.date', {
  defaultMessage: 'Date'
});
const StepPageNavigation = ({
  testRunPage
}) => {
  var _data$details, _data$details2, _data$details2$previo, _data$details3, _data$details3$next;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_journey_steps.useJourneySteps)();
  const formatter = (0, _use_date_format.useDateFormat)();
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const startedAt = formatter(data === null || data === void 0 ? void 0 : (_data$details = data.details) === null || _data$details === void 0 ? void 0 : _data$details.timestamp);
  const {
    stepIndex,
    monitorId
  } = (0, _reactRouterDom.useParams)();
  let prevHref = (0, _use_step_detail_page.useStepDetailLink)({
    stepIndex,
    checkGroupId: data === null || data === void 0 ? void 0 : (_data$details2 = data.details) === null || _data$details2 === void 0 ? void 0 : (_data$details2$previo = _data$details2.previous) === null || _data$details2$previo === void 0 ? void 0 : _data$details2$previo.checkGroup
  });
  let nextHref = (0, _use_step_detail_page.useStepDetailLink)({
    stepIndex,
    checkGroupId: data === null || data === void 0 ? void 0 : (_data$details3 = data.details) === null || _data$details3 === void 0 ? void 0 : (_data$details3$next = _data$details3.next) === null || _data$details3$next === void 0 ? void 0 : _data$details3$next.checkGroup
  });
  if (testRunPage) {
    var _data$details4, _data$details4$previo, _data$details6, _data$details6$next;
    if (data !== null && data !== void 0 && (_data$details4 = data.details) !== null && _data$details4 !== void 0 && (_data$details4$previo = _data$details4.previous) !== null && _data$details4$previo !== void 0 && _data$details4$previo.checkGroup) {
      var _data$details5, _data$details5$previo;
      prevHref = (0, _test_details_link.getTestRunDetailLink)({
        basePath,
        monitorId,
        locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id,
        checkGroup: data === null || data === void 0 ? void 0 : (_data$details5 = data.details) === null || _data$details5 === void 0 ? void 0 : (_data$details5$previo = _data$details5.previous) === null || _data$details5$previo === void 0 ? void 0 : _data$details5$previo.checkGroup
      });
    }
    if (data !== null && data !== void 0 && (_data$details6 = data.details) !== null && _data$details6 !== void 0 && (_data$details6$next = _data$details6.next) !== null && _data$details6$next !== void 0 && _data$details6$next.checkGroup) {
      var _data$details7, _data$details7$next;
      nextHref = (0, _test_details_link.getTestRunDetailLink)({
        basePath,
        monitorId,
        locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id,
        checkGroup: data === null || data === void 0 ? void 0 : (_data$details7 = data.details) === null || _data$details7 === void 0 ? void 0 : (_data$details7$next = _data$details7.next) === null || _data$details7$next === void 0 ? void 0 : _data$details7$next.checkGroup
      });
    }
  }
  const startedAtWrapped = startedAt || /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 41
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: () => setIsPopoverOpen(false),
    isOpen: isPopoverOpen,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsStepPageNavigationButton",
      style: {
        height: 20
      },
      onClick: () => setIsPopoverOpen(prev => !prev),
      iconType: "arrowDown",
      iconSide: "right",
      flush: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, startedAtWrapped),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepPageNavigationButton",
    href: prevHref,
    disabled: !prevHref,
    iconType: "arrowLeft",
    "aria-label": PREVIOUS_CHECK_BUTTON_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, PREVIOUS_CHECK_BUTTON_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textNoWrap",
    "aria-label": CURRENT_CHECK_ARIA_LABEL(startedAt),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, startedAtWrapped)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepPageNavigationButton",
    href: nextHref,
    disabled: !nextHref,
    iconType: "arrowRight",
    iconSide: "right",
    "aria-label": NEXT_CHECK_BUTTON_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, NEXT_CHECK_BUTTON_TEXT))));
};
exports.StepPageNavigation = StepPageNavigation;
const PREVIOUS_CHECK_BUTTON_TEXT = exports.PREVIOUS_CHECK_BUTTON_TEXT = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.previousCheckButtonText', {
  defaultMessage: 'Previous check'
});
const NEXT_CHECK_BUTTON_TEXT = exports.NEXT_CHECK_BUTTON_TEXT = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.nextCheckButtonText', {
  defaultMessage: 'Next check'
});
const CURRENT_CHECK_ARIA_LABEL = timestamp => _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.currentCheckAriaLabel', {
  defaultMessage: 'Current check: {timestamp}',
  values: {
    timestamp
  }
});
exports.CURRENT_CHECK_ARIA_LABEL = CURRENT_CHECK_ARIA_LABEL;