"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepNav = exports.StepDetailPageStepNav = exports.STEP_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_step_detail_page = require("./hooks/use_step_detail_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_number_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepNav = ({
  stepIndex,
  totalSteps,
  handleStepHref
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const hasMoreThanOneStep = totalSteps > 1;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepNavStepStepIndexOfTotalStepsButton",
    size: "s",
    flush: "left",
    iconType: hasMoreThanOneStep ? 'arrowDown' : undefined,
    iconSide: "right",
    onClick: onButtonClick,
    style: {
      height: 20
    },
    disabled: !hasMoreThanOneStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.stepDetail.totalSteps",
    defaultMessage: "Step {stepIndex} of {totalSteps}",
    values: {
      stepIndex,
      totalSteps
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
  const items = (0, _lodash.times)(totalSteps).map(num => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: num,
    href: handleStepHref(num + 1),
    onClick: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.synthetics.stepDetail.stepNumber",
    defaultMessage: "Step {stepIndex}",
    values: {
      stepIndex: num + 1
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "stepDetailsStepNav",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }));
};
exports.StepNav = StepNav;
const StepDetailPageStepNav = () => {
  const {
    activeStep,
    journey,
    stepIndex,
    handleStepHref,
    stepEnds
  } = (0, _use_step_detail_page.useStepDetailPage)();
  if (!journey || !activeStep) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: STEP_LABEL,
      description: /*#__PURE__*/_react.default.createElement(StepNav, {
        stepIndex: stepIndex,
        totalSteps: stepEnds.length,
        handleStepHref: handleStepHref,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 13
        }
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  });
};
exports.StepDetailPageStepNav = StepDetailPageStepNav;
const STEP_LABEL = exports.STEP_LABEL = _i18n.i18n.translate('xpack.synthetics.synthetics.stepDetail.stepLabel', {
  defaultMessage: 'Step'
});