"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _agent_policy_needed = require("./agent_policy_needed");
var _empty_locations = require("./empty_locations");
var _agent_policies = require("../../../state/agent_policies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/private_locations/manage_empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ManageEmptyState = ({
  children,
  privateLocations,
  setIsFlyoutOpen,
  showNeedAgentPolicy = true,
  showEmptyLocations = true
}) => {
  const {
    data: agentPolicies
  } = (0, _reactRedux.useSelector)(_agent_policies.selectAgentPolicies);
  if ((agentPolicies === null || agentPolicies === void 0 ? void 0 : agentPolicies.length) === 0 && showNeedAgentPolicy) {
    return /*#__PURE__*/_react.default.createElement(_agent_policy_needed.AgentPolicyNeeded, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  }
  if (privateLocations.length === 0 && showEmptyLocations) {
    return /*#__PURE__*/_react.default.createElement(_empty_locations.EmptyLocations, {
      setIsFlyoutOpen: setIsFlyoutOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.ManageEmptyState = ManageEmptyState;