"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParamsList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _table_title = require("../../common/components/table_title");
var _params_text = require("./params_text");
var _use_params_list = require("../hooks/use_params_list");
var _add_param_flyout = require("./add_param_flyout");
var _delete_param = require("./delete_param");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/global_params/params_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ParamsList = () => {
  var _application$capabili;
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const {
    items,
    isLoading
  } = (0, _use_params_list.useParamsList)();
  const [isEditingItem, setIsEditingItem] = (0, _react.useState)(null);
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const [deleteParam, setDeleteParam] = (0, _react.useState)([]);
  const {
    application
  } = (0, _public.useKibana)().services;
  const canSave = (_application$capabili = application === null || application === void 0 ? void 0 : application.capabilities.uptime.save) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const columns = [{
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.key', {
      defaultMessage: 'Key'
    }),
    sortable: true,
    field: 'key'
  }, {
    align: 'left',
    width: '20%',
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.value', {
      defaultMessage: 'Value'
    }),
    render: item => {
      var _item$value;
      return /*#__PURE__*/_react.default.createElement(_params_text.ParamsText, {
        text: (_item$value = item.value) !== null && _item$value !== void 0 ? _item$value : '',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 40
        }
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.description', {
      defaultMessage: 'Description'
    }),
    field: 'description',
    sortable: true,
    render: val => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 32
      }
    }, val !== null && val !== void 0 ? val : '--')
  }, {
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.tags', {
      defaultMessage: 'Tags'
    }),
    field: 'tags',
    sortable: true,
    render: val => {
      const tags = val !== null && val !== void 0 ? val : [];
      if (tags.length === 0) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 87,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.synthetics.columns.TextLabel', {
          defaultMessage: '--'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        wrap: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 11
        }
      }, tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: tag,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 17
        }
      }, tag))));
    }
  }, {
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.namespaces', {
      defaultMessage: 'Namespaces'
    }),
    field: 'namespaces',
    sortable: true,
    render: val => {
      const namespaces = val !== null && val !== void 0 ? val : [];
      if (namespaces.length === 0) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.synthetics.columns.TextLabel', {
          defaultMessage: '--'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        wrap: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 11
        }
      }, namespaces.map(namespace => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: namespace,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 17
        }
      }, namespace === '*' ? 'ALL' : namespace))));
    }
  }, {
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: DELETE_PARAM,
      description: DELETE_PARAM,
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: item => {
        setDeleteParam([item]);
        setIsDeleteModalVisible(true);
      },
      'data-test-subj': 'action-delete',
      enabled: () => canSave
    }, {
      name: EDIT_PARAM,
      description: EDIT_PARAM,
      icon: 'pencil',
      type: 'icon',
      onClick: item => {
        setIsEditingItem(item);
      },
      'data-test-subj': 'action-edit',
      enabled: () => canSave
    }]
  }];
  const tagsList = items.reduce((acc, item) => {
    const tags = item.tags || [];
    return new Set([...acc, ...tags]);
  }, new Set());
  const renderToolsLeft = () => {
    if (selectedItems.length === 0) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsRenderToolsLeftParamsButton",
      color: "danger",
      onClick: () => {
        setDeleteParam(selectedItems);
        setIsDeleteModalVisible(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.deleteCount', {
      defaultMessage: 'Delete {count} params',
      values: {
        count: selectedItems.length
      }
    }));
  };
  const renderToolRight = () => {
    return [/*#__PURE__*/_react.default.createElement(_add_param_flyout.AddParamFlyout, {
      isEditingItem: isEditingItem,
      setIsEditingItem: setIsEditingItem,
      items: items,
      key: "add-param-flyout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 7
      }
    })];
  };
  const [query, setQuery] = (0, _react.useState)('');
  const [debouncedValue, setDebouncedValue] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => {
    setDebouncedValue(query);
  }, 200, [query]);
  const [filteredItems, setFilteredItems] = (0, _react.useState)(items);
  (0, _react.useEffect)(() => {
    if (!debouncedValue) {
      setFilteredItems(items);
    } else {
      const queriedItems = _eui.EuiSearchBar.Query.execute(debouncedValue, items, {
        defaultFields: ['key', 'description', 'tags']
      });
      setFilteredItems(queriedItems);
    }
  }, [debouncedValue, items]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.params.description",
    defaultMessage: "Define variables and parameters that you can use in the configuration of browser and lightweight monitors, such as credentials or URLs. {learnMore}",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsParamsListLink",
        href: "https://www.elastic.co/guide/en/observability/current/synthetics-params-secrets.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 15
        }
      }, LEARN_MORE)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    itemId: "id",
    loading: isLoading,
    tableCaption: PARAMS_TABLE,
    items: filteredItems,
    columns: columns,
    tableLayout: "auto",
    pagination: true,
    sorting: {
      sort: {
        field: 'key',
        direction: 'asc'
      }
    },
    childrenBetween: /*#__PURE__*/_react.default.createElement(_table_title.TableTitle, {
      pageIndex: pageIndex,
      pageSize: pageSize,
      total: filteredItems.length,
      label: PARAMS_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 11
      }
    }),
    onTableChange: ({
      page
    }) => {
      var _page$index, _page$size;
      setPageIndex((_page$index = page === null || page === void 0 ? void 0 : page.index) !== null && _page$index !== void 0 ? _page$index : 0);
      setPageSize((_page$size = page === null || page === void 0 ? void 0 : page.size) !== null && _page$size !== void 0 ? _page$size : 10);
    },
    selection: {
      selectable: () => canSave,
      onSelectionChange: sItems => {
        setSelectedItems(sItems);
      },
      initialSelected: selectedItems
    },
    search: {
      onChange: ({
        query: queryText
      }) => {
        var _queryText$text;
        return setQuery((_queryText$text = queryText === null || queryText === void 0 ? void 0 : queryText.text) !== null && _queryText$text !== void 0 ? _queryText$text : '');
      },
      toolsLeft: renderToolsLeft(),
      toolsRight: renderToolRight(),
      box: {
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        field: 'tags',
        name: 'Tags',
        multiSelect: true,
        options: [...tagsList].map(tag => ({
          value: tag,
          name: tag,
          view: tag
        }))
      }]
    },
    message: isLoading ? LOADING_TEXT : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }), isDeleteModalVisible && deleteParam && /*#__PURE__*/_react.default.createElement(_delete_param.DeleteParam, {
    items: deleteParam,
    setIsDeleteModalVisible: setIsDeleteModalVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 9
    }
  }));
};
exports.ParamsList = ParamsList;
const PARAMS_TABLE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.tableCaption', {
  defaultMessage: 'Synthetics Global Parameters'
});
const PARAMS_LABEL = _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.label', {
  defaultMessage: 'Parameters'
});
const LEARN_MORE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.learnMore', {
  defaultMessage: 'Learn more.'
});
const EDIT_PARAM = _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.editLabel', {
  defaultMessage: 'Edit Parameter'
});
const LOADING_TEXT = _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.loading', {
  defaultMessage: 'Loading...'
});
const DELETE_PARAM = _i18n.i18n.translate('xpack.synthetics.settingsRoute.params.addLabel', {
  defaultMessage: 'Delete Parameter'
});