"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmRetentionTab = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _policy_link = require("../policy_link");
var _use_get_ilm_policies = require("../hooks/use_get_ilm_policies");
var _unprivileged = require("./unprivileged");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/data_retention/ilm_retention_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IlmRetentionTab = () => {
  var _body;
  const {
    data,
    loading,
    error
  } = (0, _use_get_ilm_policies.useGetIlmPolicies)();
  if (error && ((_body = error.body) === null || _body === void 0 ? void 0 : _body.statusCode) === 403) {
    return /*#__PURE__*/_react.default.createElement(_unprivileged.Unprivileged, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 12
      }
    });
  }
  const columns = [{
    field: 'label',
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.dataset', {
      defaultMessage: 'Dataset'
    })
  }, {
    field: 'currentSize',
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.currentSize', {
      defaultMessage: 'Current size'
    })
  }, {
    field: 'retentionPeriod',
    name: _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.retentionPeriod', {
      defaultMessage: 'Retention period'
    })
  }, {
    field: 'policy.name',
    name: /*#__PURE__*/_react.default.createElement(_policy_link.PolicyNameLabel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 13
      }
    }),
    render: (name, _item) => /*#__PURE__*/_react.default.createElement(_policy_link.PolicyLink, {
      name: name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 58
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: CALLOUT_TITLE,
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.settingsRoute.retentionCalloutDescription",
    defaultMessage: "To change your data retention settings, we recommend creating your own index lifecycle policy and attaching it to the relevant custom Component Template in {stackManagement}. For more information, {docsLink}.",
    values: {
      stackManagement: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 32
        }
      }, STACK_MANAGEMENT),
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsDataRetentionTabLink",
        href: "https://www.elastic.co/guide/en/observability/current/synthetics-manage-retention.html",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 17
        }
      }, READ_OUR_DOCS)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: loading,
    tableCaption: RETENTION_TABLE,
    items: data,
    columns: columns,
    tableLayout: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
};
exports.IlmRetentionTab = IlmRetentionTab;
const CALLOUT_TITLE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.retentionCalloutTitle', {
  defaultMessage: 'Synthetics data is configured by managed index lifecycle policies'
});
const STACK_MANAGEMENT = _i18n.i18n.translate('xpack.synthetics.stackManagement', {
  defaultMessage: 'Stack Management'
});
const READ_OUR_DOCS = _i18n.i18n.translate('xpack.synthetics.settingsRoute.readDocs', {
  defaultMessage: 'read our documentation'
});
const RETENTION_TABLE = _i18n.i18n.translate('xpack.synthetics.settingsRoute.tableCaption', {
  defaultMessage: 'Synthetics data retention policies'
});