"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewStatus = OverviewStatus;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _embeddable_panel_wrapper = require("../../../common/components/embeddable_panel_wrapper");
var _overview_status = require("../../../../state/overview_status");
var _kibana_service = require("../../../../../../utils/kibana_service");
var _use_url_params = require("../../../../hooks/use_url_params");
var _use_overview_status = require("../../hooks/use_overview_status");
var _plugin = require("../../../../../../../common/constants/plugin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/overview_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function title(t) {
  return t !== null && t !== void 0 ? t : '-';
}
const MonitorStat = ({
  dataTestSubj,
  statName,
  statNo,
  numberColor,
  isClickable,
  onClickStat
}) => {
  const statComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": dataTestSubj,
    description: statName,
    reverse: true,
    title: statNo,
    titleColor: numberColor,
    titleSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
  return isClickable ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `${dataTestSubj}Btn`,
    onClick: onClickStat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, statComponent) : statComponent;
};
function OverviewStatus({
  titleAppend,
  hideTitle,
  areStatsClickable = false
}) {
  const {
    statusFilter
  } = (0, _use_url_params.useGetUrlParams)();
  const {
    application
  } = (0, _public.useKibana)().services;
  const {
    status,
    error: statusError,
    loading
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const [statusConfig, setStatusConfig] = (0, _react.useState)({
    up: status === null || status === void 0 ? void 0 : status.up,
    down: status === null || status === void 0 ? void 0 : status.down,
    pending: status === null || status === void 0 ? void 0 : status.pending,
    disabledCount: status === null || status === void 0 ? void 0 : status.disabledCount
  });
  (0, _react.useEffect)(() => {
    if (statusError) {
      dispatch((0, _overview_status.clearOverviewStatusErrorAction)());
      _kibana_service.kibanaService.toasts.addError(statusError.body, {
        title: errorToastTitle,
        toastLifeTimeMs: 5000
      });
    }
  }, [dispatch, statusError]);
  (0, _react.useEffect)(() => {
    if (statusFilter) {
      switch (statusFilter) {
        case 'up':
          setStatusConfig({
            up: (status === null || status === void 0 ? void 0 : status.up) || 0,
            down: 0,
            disabledCount: 0,
            pending: 0
          });
          break;
        case 'down':
          setStatusConfig({
            up: 0,
            down: (status === null || status === void 0 ? void 0 : status.down) || 0,
            disabledCount: 0,
            pending: 0
          });
          break;
        case 'disabled':
          setStatusConfig({
            up: 0,
            down: 0,
            disabledCount: (status === null || status === void 0 ? void 0 : status.disabledCount) || 0,
            pending: 0
          });
          break;
        case 'pending':
          setStatusConfig({
            up: 0,
            down: 0,
            disabledCount: 0,
            pending: (status === null || status === void 0 ? void 0 : status.pending) || 0
          });
          break;
      }
    } else if (status) {
      setStatusConfig({
        up: status.up,
        down: status.down,
        disabledCount: status.disabledCount,
        pending: status === null || status === void 0 ? void 0 : status.pending
      });
    }
  }, [status, statusFilter]);
  const getOnClickStat = (0, _react.useCallback)(statusFilterName => {
    return () => {
      application === null || application === void 0 ? void 0 : application.navigateToApp(_plugin.PLUGIN.SYNTHETICS_PLUGIN_ID, {
        path: `?statusFilter=${statusFilterName}`
      });
    };
  }, [application]);
  const monitorStatData = (0, _react.useMemo)(() => {
    const stats = [{
      dataTestSubj: 'syntheticsOverviewUp',
      statName: upDescription,
      statNo: title(statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.up),
      numberColor: 'success',
      isClickable: areStatsClickable,
      onClickStat: getOnClickStat('up')
    }, {
      dataTestSubj: 'syntheticsOverviewDown',
      statName: downDescription,
      statNo: title(statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.down),
      numberColor: 'danger',
      isClickable: areStatsClickable,
      onClickStat: getOnClickStat('down')
    }, {
      dataTestSubj: 'xpack.uptime.synthetics.overview.status.disabled',
      statName: disabledDescription,
      statNo: title(statusConfig === null || statusConfig === void 0 ? void 0 : statusConfig.disabledCount),
      numberColor: 'subdued',
      isClickable: areStatsClickable,
      onClickStat: getOnClickStat('disabled')
    }];
    if (statusConfig !== null && statusConfig !== void 0 && statusConfig.pending) {
      stats.push({
        dataTestSubj: 'xpack.uptime.synthetics.overview.status.pending',
        statName: pendingDescription,
        statNo: title(statusConfig.pending),
        numberColor: 'subdued',
        isClickable: areStatsClickable,
        onClickStat: getOnClickStat('pending')
      });
    }
    return stats;
  }, [areStatsClickable, getOnClickStat, statusConfig]);
  return /*#__PURE__*/_react.default.createElement(_embeddable_panel_wrapper.EmbeddablePanelWrapper, {
    title: headingText,
    loading: loading,
    titleAppend: titleAppend,
    hideTitle: hideTitle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    justifyContent: "spaceAround",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, monitorStatData.map(props => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: props.dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(MonitorStat, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }))))));
}
const headingText = _i18n.i18n.translate('xpack.synthetics.overview.monitors.headingText', {
  defaultMessage: 'Monitors status'
});
const upDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.up.description', {
  defaultMessage: 'Up'
});
const downDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.down.description', {
  defaultMessage: 'Down'
});
const pendingDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.pending.description', {
  defaultMessage: 'Pending'
});
const disabledDescription = _i18n.i18n.translate('xpack.synthetics.overview.status.disabled.description', {
  defaultMessage: 'Disabled'
});
const errorToastTitle = _i18n.i18n.translate('xpack.synthetics.overview.status.error.title', {
  defaultMessage: 'Unable to get monitor status metrics'
});