"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricValueProps = exports.getColor = exports.MetricItem = exports.METRIC_ITEM_HEIGHT = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _metric_item_extra = require("./metric_item_extra");
var _hooks = require("../../../../../hooks");
var _state = require("../../../../../state");
var _manual_test_runs = require("../../../../../state/manual_test_runs");
var _formatting = require("../../../../../utils/formatting");
var _actions_popover = require("../actions_popover");
var _metric_item_body = require("./metric_item_body");
var _metric_item_icon = require("./metric_item_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/metric_item/metric_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const METRIC_ITEM_HEIGHT = exports.METRIC_ITEM_HEIGHT = 180;
const getColor = (euiTheme, isEnabled, status) => {
  if (!isEnabled) {
    return euiTheme.colors.backgroundBaseDisabled;
  }
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;

  // make sure these are synced with slo card colors while making changes

  switch (status) {
    case 'down':
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText9 : euiTheme.colors.backgroundBaseDanger;
    case 'up':
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText0 : euiTheme.colors.backgroundBaseSuccess;
    case 'unknown':
      return euiTheme.colors.backgroundBasePlain;
    default:
      return isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText0 : euiTheme.colors.backgroundBaseSuccess;
  }
};
exports.getColor = getColor;
const truncateText = text => {
  // truncate from middle if longer than maxLength
  const maxLength = 100;
  if (text.length <= maxLength) {
    return text;
  }
  const halfLength = Math.floor(maxLength / 2);
  return `${text.slice(0, halfLength)}…${text.slice(-halfLength)}`;
};

/**
 * Get metric value props for Metric component. The goal of this function is
 * to be able to handle the loading state of the trend data without disrupting
 * the type expectations of the Metric component.
 */
const getMetricValueProps = trendData => {
  if (trendData === 'loading') return {
    value: '',
    extra: /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      ariaWrapperProps: {
        style: {
          height: '16px',
          width: '50px'
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    })
  };
  if (!trendData || trendData.median === null) {
    return {
      value: '',
      extra: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.overview.metricItem.noDataAvailableMessage",
        defaultMessage: "--",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      })
    };
  }
  return {
    value: trendData.median,
    valueFormatter: d => (0, _formatting.formatDuration)(d),
    extra: /*#__PURE__*/_react2.default.createElement(_metric_item_extra.MetricItemExtra, {
      stats: {
        medianDuration: trendData.median,
        minDuration: trendData.min,
        maxDuration: trendData.max,
        avgDuration: trendData.avg
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    })
  };
};
exports.getMetricValueProps = getMetricValueProps;
const MetricItem = ({
  monitor,
  onClick,
  style
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const trendData = (0, _reactRedux.useSelector)(_state.selectOverviewTrends)[monitor.configId + monitor.locationId];
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const isErrorPopoverOpen = (0, _reactRedux.useSelector)(_state.selectErrorPopoverState);
  const locationName = (0, _hooks.useLocationName)(monitor);
  const {
    status,
    timestamp,
    configIdByLocation
  } = (0, _hooks.useStatusByLocationOverview)({
    configId: monitor.configId,
    locationId: monitor.locationId
  });
  const {
    charts
  } = (0, _public.useKibana)().services;
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  const testInProgress = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunInProgressSelector)(monitor.configId));
  const dispatch = (0, _reactRedux.useDispatch)();
  const trendMessage = (0, _react2.useMemo)(() => {
    if (trendData === 'loading') {
      return _i18n.i18n.translate('xpack.synthetics.overview.metricItem.trendMessage.loadingCase', {
        defaultMessage: 'Metrics are loading and have no value to display.'
      });
    }
    if (!trendData) {
      return _i18n.i18n.translate('xpack.synthetics.overview.metricItem.trendMessage.noData', {
        defaultMessage: 'No data available for the selected time window.'
      });
    }
    return _i18n.i18n.translate('xpack.synthetics.overview.metricItem.trendMessage', {
      defaultMessage: 'The duration statistics currently shown by the chart are: average: {avg}, median: {median}, max: {max}, min: {min}.',
      values: {
        max: trendData.max,
        min: trendData.min,
        median: trendData.median,
        avg: trendData.avg
      }
    });
  }, [trendData]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": `${monitor.name}-${monitor.locationId}-metric-item`,
    "aria-label": _i18n.i18n.translate('xpack.synthetics.overview.metricItem.label', {
      defaultMessage: 'Monitor {name} in {location}. The background of this element also contains a sparkline chart indicating the status of test duration over the selected time window. {trendMessage}',
      values: {
        name: monitor.name,
        location: locationName,
        trendMessage
      }
    })
    // this is the ID the Chart child will expect in its `aria-labelledby` attribute
    ,
    id: `echMetric-${monitor.configId}-${monitor.locationId}-metric-chart-0-0-trend-title_echMetric-${monitor.configId}-${monitor.locationId}-metric-chart-0-0-trend-description`,
    style: style !== null && style !== void 0 ? style : {
      height: METRIC_ITEM_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `${monitor.name}-metric-item-${locationName}-${status}`,
    paddingSize: "none",
    onMouseLeave: () => {
      if (isErrorPopoverOpen) {
        dispatch((0, _state.toggleErrorPopoverOpen)(null));
      }
    },
    css: (0, _react.css)`
          height: 100%;
          overflow: hidden;
          position: relative;

          & .cardItemActions_hover {
            pointer-events: none;
            opacity: 0;
            &:focus-within {
              pointer-events: auto;
              opacity: 1;
            }
          }
          &:hover .cardItemActions_hover {
            pointer-events: auto;
            opacity: 1;
          }
          .echMetricText__body {
            overflow: visible;
          }
        `,
    title: (0, _moment.default)(timestamp).format('LLL'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_charts.Chart, {
    id: `${monitor.configId}-${monitor.locationId}-metric-chart`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_charts.Settings, {
    onElementClick: () => {
      if (testInProgress) {
        dispatch((0, _manual_test_runs.toggleTestNowFlyoutAction)(monitor.configId));
        dispatch((0, _state.toggleErrorPopoverOpen)(null));
      } else {
        dispatch((0, _manual_test_runs.hideTestNowFlyoutAction)());
        dispatch((0, _state.toggleErrorPopoverOpen)(null));
      }
      if (!testInProgress && locationName) {
        onClick({
          configId: monitor.configId,
          id: monitor.configId,
          location: locationName,
          locationId: monitor.locationId,
          spaces: monitor.spaces
        });
      }
    },
    baseTheme: chartBaseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_charts.Metric, {
    id: `${monitor.configId}-${monitor.locationId}`,
    data: [[{
      title: truncateText(monitor.name),
      subtitle: locationName,
      body: /*#__PURE__*/_react2.default.createElement(_metric_item_body.MetricItemBody, {
        monitor: monitor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 253,
          columnNumber: 25
        }
      }),
      color: getColor(euiTheme, monitor.isEnabled, status),
      trendShape: _charts.MetricTrendShape.Area,
      trend: trendData !== 'loading' && !!(trendData !== null && trendData !== void 0 && trendData.data) ? trendData.data : [],
      ...getMetricValueProps(trendData)
    }]],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement("div", {
    className: isPopoverOpen ? '' : 'cardItemActions_hover',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_actions_popover.ActionsPopover, {
    monitor: monitor,
    isPopoverOpen: isPopoverOpen,
    setIsPopoverOpen: setIsPopoverOpen,
    position: "relative",
    locationId: monitor.locationId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 11
    }
  })), configIdByLocation && /*#__PURE__*/_react2.default.createElement(_metric_item_icon.MetricItemIcon, {
    monitor: monitor,
    status: status,
    timestamp: timestamp,
    configIdByLocation: configIdByLocation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }));
};
exports.MetricItem = MetricItem;