"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupGridItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _useKey = _interopRequireDefault(require("react-use/lib/useKey"));
var _overview_loader = require("../overview_loader");
var _use_filtered_group_monitors = require("./use_filtered_group_monitors");
var _overview_status = require("../../../../../state/overview_status");
var _metric_item = require("../metric_item/metric_item");
var _monitors_table = require("../compact_view/components/monitors_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/grid_by_group/grid_group_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PER_ROW = 4;
const DEFAULT_ROW_SIZE = 2;
const GroupGridCardContent = ({
  isLoading,
  setFlyoutConfigCallback,
  groupMonitors
}) => {
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [rowSize, setRowSize] = (0, _react.useState)(DEFAULT_ROW_SIZE);
  const visibleMonitors = groupMonitors.slice(activePage * rowSize * PER_ROW, (activePage + 1) * rowSize * PER_ROW);
  const totalEntries = groupMonitors.length / PER_ROW;
  const goToPage = pageNumber => setActivePage(pageNumber);
  const changeItemsPerPage = pageSize => {
    setRowSize(pageSize);
    setActivePage(0);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4,
    gutterSize: "m",
    "data-test-subj": "syntheticsOverviewGridItemContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, visibleMonitors.map(monitor => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `${monitor.configId}-${monitor.locationId}`,
    "data-test-subj": "syntheticsOverviewGridItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    monitor: monitor,
    onClick: setFlyoutConfigCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  })))) : /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, {
    rows: rowSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "aria-label": _i18n.i18n.translate('xpack.synthetics.groupGridItem.euiTablePagination.monitorGridPaginationLabel', {
      defaultMessage: 'Monitor grid pagination'
    }),
    pageCount: Math.ceil(totalEntries / rowSize),
    activePage: activePage,
    onChangePage: goToPage,
    itemsPerPage: rowSize,
    onChangeItemsPerPage: changeItemsPerPage,
    itemsPerPageOptions: [2, 3, 4, 5, 10],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
};
const GroupGridItem = ({
  loaded,
  groupLabel,
  fullScreenGroup,
  setFullScreenGroup,
  groupMonitors: allGroupMonitors,
  setFlyoutConfigCallback,
  view
}) => {
  const {
    status: overviewStatus
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const groupMonitors = (0, _use_filtered_group_monitors.useFilteredGroupMonitors)({
    groupMonitors: allGroupMonitors
  });
  const downMonitors = groupMonitors.filter(monitor => {
    const downConfigs = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.downConfigs;
    if (downConfigs) {
      var _downConfigs;
      return ((_downConfigs = downConfigs[`${monitor.configId}-${monitor.locationId}`]) === null || _downConfigs === void 0 ? void 0 : _downConfigs.status) === 'down';
    }
  });
  const downMonitorsCount = downMonitors.length;
  const {
    status
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  (0, _useKey.default)('Escape', () => {
    if (fullScreenGroup === groupLabel) {
      setFullScreenGroup('');
    }
  });
  const isLoading = !loaded || !status;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: fullScreenGroup === groupLabel,
    isDisabled: fullScreenGroup === groupLabel || groupMonitors.length === 0,
    id: 'groupAccordion' + groupLabel,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textNoWrap",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }, groupLabel), downMonitorsCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textNoWrap",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "accent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }, downMonitorsCount))),
    extraAction: isLoading ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "syntheticsGroupGridItemButton",
      isDisabled: groupMonitors.length === 0,
      className: "fullScreenButton",
      iconType: "fullScreen",
      "aria-label": _i18n.i18n.translate('xpack.synthetics.groupGridItem.euiButtonIcon.fullScreenLabel', {
        defaultMessage: 'Full screen'
      }),
      onClick: () => {
        if (fullScreenGroup) {
          setFullScreenGroup('');
          document.exitFullscreen();
        } else {
          document.documentElement.requestFullscreen();
          setFullScreenGroup(groupLabel);
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.synthetics.groupGridItem.monitorsBadgeLabel.downCount', {
      defaultMessage: '{downCount} Down',
      values: {
        downCount: downMonitorsCount
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.synthetics.groupGridItem.monitorsBadgeLabel.upCount', {
      defaultMessage: '{upCount} Up',
      values: {
        upCount: groupMonitors.length - downMonitorsCount
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.synthetics.groupGridItem.monitorsBadgeLabel.count', {
      defaultMessage: '{count, number} {count, plural, one {monitor} other {monitors}}',
      values: {
        count: groupMonitors.length
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), view === 'cardView' ? /*#__PURE__*/_react.default.createElement(GroupGridCardContent, {
    isLoading: isLoading,
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    groupMonitors: groupMonitors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }) : null, view === 'compactView' ? /*#__PURE__*/_react.default.createElement(_monitors_table.MonitorsTable, {
    items: groupMonitors,
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }) : null);
};
exports.GroupGridItem = GroupGridItem;