"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var labels = _interopRequireWildcard(require("../labels"));
var _monitor_test_runs = require("./monitor_test_runs");
var _monitor_test_runs_sparkline = require("./monitor_test_runs_sparkline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_stats/monitor_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorStats = ({
  overviewStatus
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "syntheticsManagementSummaryStats",
    css: {
      display: 'flex',
      flexDirection: 'column',
      gap: euiTheme.size.l,
      flexGrow: 1
    },
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }, labels.SUMMARY_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'flex',
      flexDirection: 'row',
      gap: euiTheme.size.l
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(MonitorStat, {
    description: labels.CONFIGURATIONS_LABEL,
    value: overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.allMonitorsCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(MonitorStat, {
    description: labels.DISABLED_LABEL,
    value: overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.disabledMonitorsCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: {
      display: 'flex',
      flexDirection: 'column',
      gap: euiTheme.size.l,
      flexGrow: 12,
      minWidth: 260
    },
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, labels.getLastXDaysLabel(30))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      display: 'flex',
      flexDirection: 'row',
      gap: euiTheme.size.l,
      height: '200px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_test_runs.MonitorTestRunsCount, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_test_runs_sparkline.MonitorTestRunsSparkline, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }))))));
};
exports.MonitorStats = MonitorStats;
const EuiStatStyled = (0, _common.euiStyled)(_eui.EuiStat)`
  &&& {
  color: ${({
  theme
}) => theme.eui.euiTitleColor};
    .euiStat__title {
        color: ${({
  theme
}) => theme.eui.euiTitleColor};
        font-size: ${({
  theme
}) => theme.eui.euiFontSizeXL};
    }
  }
`;
const MonitorStat = ({
  description,
  value
}) => {
  var _ref;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const statValue = (_ref = value) !== null && _ref !== void 0 ? _ref : undefined;
  return /*#__PURE__*/_react.default.createElement(EuiStatStyled, {
    description: description,
    isLoading: isNaN(statValue),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      css: {
        fontSize: euiTheme.size.m
      },
      value: statValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 14
      }
    }),
    reverse: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  });
};