"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _state = require("../../../../state");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _use_monitor_detail_locator = require("../../../../hooks/use_monitor_detail_locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_list_table/monitor_details_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorDetailsLink = ({
  monitor
}) => {
  var _monitor$ConfigKey$LO, _monitor$ConfigKey$LO2, _monitor$ConfigKey$LO3;
  const lastSelectedLocationId = (0, _reactRedux.useSelector)(_state.selectSelectedLocationId);
  const monitorHasLocation = (_monitor$ConfigKey$LO = monitor[_runtime_types.ConfigKey.LOCATIONS]) === null || _monitor$ConfigKey$LO === void 0 ? void 0 : _monitor$ConfigKey$LO.find(loc => loc.id === lastSelectedLocationId);
  const firstMonitorLocationId = (_monitor$ConfigKey$LO2 = monitor[_runtime_types.ConfigKey.LOCATIONS]) === null || _monitor$ConfigKey$LO2 === void 0 ? void 0 : (_monitor$ConfigKey$LO3 = _monitor$ConfigKey$LO2[0]) === null || _monitor$ConfigKey$LO3 === void 0 ? void 0 : _monitor$ConfigKey$LO3.id;
  const locationId = lastSelectedLocationId && monitorHasLocation ? lastSelectedLocationId : firstMonitorLocationId;
  const monitorDetailLinkUrl = (0, _use_monitor_detail_locator.useMonitorDetailLocator)({
    configId: monitor[_runtime_types.ConfigKey.CONFIG_ID],
    locationId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorDetailsLinkLink",
    href: monitorDetailLinkUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, monitor.name);
};
exports.MonitorDetailsLink = MonitorDetailsLink;