"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInlineErrorsCount = useInlineErrorsCount;
var _reactRedux = require("react-redux");
var _react = require("react");
var _public = require("@kbn/observability-shared-plugin/public");
var _state = require("../../../state");
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _use_inline_errors = require("./use_inline_errors");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useInlineErrorsCount() {
  const syntheticsMonitors = (0, _reactRedux.useSelector)(_state.selectEncryptedSyntheticsSavedMonitors);
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const {
    data,
    loading
  } = (0, _public.useEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    size: 0,
    query: {
      bool: {
        filter: (0, _use_inline_errors.getInlineErrorFilters)()
      }
    },
    aggs: {
      total: {
        cardinality: {
          field: 'monitor.id'
        }
      }
    }
  }, [syntheticsMonitors, lastRefresh], {
    name: 'getInvalidMonitorsCount'
  });
  return (0, _react.useMemo)(() => {
    var _data$aggregations;
    const errorSummariesCount = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.total.value;
    return {
      loading: loading !== null && loading !== void 0 ? loading : false,
      count: errorSummariesCount
    };
  }, [data, loading]);
}