"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../../../../../../common/constants");
var _filter_fields = require("../../../../utils/filters/filter_fields");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/common/monitor_filters/filter_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FilterButton = ({
  filter,
  handleFilterChange,
  loading
}) => {
  var _urlParams$useLogical;
  const {
    label,
    values,
    field
  } = filter;
  const [query, setQuery] = (0, _react.useState)('');
  const urlParams = (0, _hooks.useGetUrlParams)();

  // Transform the values to readable labels (if any) so that selected values are checked on filter dropdown
  const selectedValueLabels = (0, _filter_fields.getSyntheticsFilterDisplayValues)((0, _filter_fields.valueToLabelWithEmptyCount)(urlParams[field]), field, []).map(({
    label: selectedValueLabel
  }) => selectedValueLabel);
  const showLogicalConditionSwitch = (0, _constants.isLogicalAndField)(field);
  return /*#__PURE__*/_react.default.createElement(_public.FieldValueSelection, {
    selectedValue: selectedValueLabels,
    singleSelection: false,
    label: label,
    values: query ? values.filter(({
      label: str
    }) => str.toLowerCase().includes(query.toLowerCase())) : values,
    setQuery: setQuery,
    onChange: (selectedValues, _, isLogicalAND) => handleFilterChange(field, selectedValues, isLogicalAND),
    allowExclusions: false,
    loading: loading,
    asFilterButton: true,
    showLogicalConditionSwitch: showLogicalConditionSwitch,
    useLogicalAND: showLogicalConditionSwitch && ((_urlParams$useLogical = urlParams.useLogicalAndFor) === null || _urlParams$useLogical === void 0 ? void 0 : _urlParams$useLogical.includes(field)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
};
exports.FilterButton = FilterButton;