"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorAlerts = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
var _use_selected_location = require("../hooks/use_selected_location");
var _alert_actions = require("./alert_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/monitor_alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MONITOR_STATUS_RULE = {
  'kibana.alert.rule.category': ['Synthetics monitor status']
};
const MonitorAlerts = ({
  to,
  from,
  dateLabel
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public2.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isAmsterdam = euiTheme.flags.hasVisColorAdjustment;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  if (!selectedLocation || !queryIdFilter) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "m",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, ALERTS_LABEL, " (", /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'inline-block'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    noLabel: true,
    fontSize: 16,
    lineHeight: 27,
    withActions: false,
    customHeight: '27px',
    reportType: "single-metric",
    attributes: [{
      dataType: 'alerts',
      time: {
        from,
        to
      },
      name: 'All',
      selectedMetricField: _public.RECORDS_FIELD,
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      filters: locationFilter !== null && locationFilter !== void 0 ? locationFilter : []
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 17
    }
  })), ")"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, dateLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_actions.AlertActions, {
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: 80
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    dataTestSubj: "monitorActiveAlertsCount",
    customHeight: '120px',
    reportType: "single-metric",
    attributes: [{
      dataType: 'alerts',
      time: {
        from,
        to
      },
      name: ACTIVE_LABEL,
      selectedMetricField: _public.RECORDS_FIELD,
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      filters: [{
        field: 'kibana.alert.status',
        values: ['active']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])]
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 80
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    sparklineMode: true,
    customHeight: "100px",
    reportType: "kpi-over-time",
    attributes: [{
      seriesType: 'area',
      time: {
        from,
        to
      },
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      dataType: 'alerts',
      selectedMetricField: _public.RECORDS_FIELD,
      name: ACTIVE_LABEL,
      filters: [{
        field: 'kibana.alert.status',
        values: ['active']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])],
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText7 : euiTheme.colors.vis.euiColorVis7
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 85,
      marginLeft: 40
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    customHeight: '120px',
    reportType: "single-metric",
    attributes: [{
      dataType: 'alerts',
      time: {
        from,
        to
      },
      name: RECOVERED_LABEL,
      selectedMetricField: _public.RECORDS_FIELD,
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      filters: [{
        field: 'kibana.alert.status',
        values: ['recovered']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])]
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 80
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    sparklineMode: true,
    customHeight: "100px",
    reportType: "kpi-over-time",
    attributes: [{
      seriesType: 'area',
      time: {
        from,
        to
      },
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      dataType: 'alerts',
      selectedMetricField: 'recovered_alerts',
      name: RECOVERED_LABEL,
      filters: [{
        field: 'kibana.alert.status',
        values: ['recovered']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])],
      color: isAmsterdam ? euiTheme.colors.vis.euiColorVisBehindText0 : euiTheme.colors.vis.euiColorVis0
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }))));
};
exports.MonitorAlerts = MonitorAlerts;
const ALERTS_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.alerts', {
  defaultMessage: 'Alerts'
});
const ACTIVE_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.alerts.active', {
  defaultMessage: 'Active'
});
const RECOVERED_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.alerts.recovered', {
  defaultMessage: 'Recovered'
});