"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorPendingWrapper = exports.MONITOR_PENDING_HEADING = exports.MONITOR_PENDING_CONTENT = exports.LOADING_TITLE = exports.LOADING_DESCRIPTION = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _page_loader = require("../common/components/page_loader");
var _state = require("../../state");
var _use_monitor_latest_ping = require("./hooks/use_monitor_latest_ping");
var _contexts = require("../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_pending_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorPendingWrapper = ({
  children
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const history = (0, _reactRouterDom.useHistory)();
  const currentLocation = (0, _reactRouterDom.useLocation)();
  const locationRef = (0, _react.useRef)(currentLocation);
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    refreshApp
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    latestPing,
    loaded: pingsLoaded
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  const [loaded, setLoaded] = (0, _react.useState)(false);
  const [hasPing, setHasPing] = (0, _react.useState)(false);
  const unlisten = (0, _react.useMemo)(() => history.listen(location => {
    const currentMonitorId = location.pathname.split('/')[2] || '';
    const hasDifferentSearch = locationRef.current.search !== location.search;
    const hasDifferentId = currentMonitorId !== monitorId;
    locationRef.current = location;
    if (hasDifferentSearch || hasDifferentId) {
      setLoaded(false);
      setHasPing(false);
      dispatch((0, _state.resetMonitorLastRunAction)());
      refreshApp();
    }
  }), [history, monitorId, dispatch, refreshApp]);
  (0, _react.useEffect)(() => {
    return function cleanup() {
      unlisten();
    };
  }, [unlisten]);
  (0, _react.useEffect)(() => {
    if (pingsLoaded) {
      setLoaded(true);
    }
    if (pingsLoaded && latestPing) {
      setHasPing(true);
    }
  }, [pingsLoaded, latestPing, dispatch, unlisten]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !loaded ? /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 17
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 18
      }
    }, LOADING_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 17
      }
    }, LOADING_DESCRIPTION),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }) : null, loaded && !hasPing ? /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 17
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 18
      }
    }, MONITOR_PENDING_HEADING),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 17
      }
    }, MONITOR_PENDING_CONTENT),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement("div", {
    style: loaded && hasPing ? undefined : {
      display: 'none'
    },
    "data-test-subj": "syntheticsPendingWrapperChildren",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, children));
};
exports.MonitorPendingWrapper = MonitorPendingWrapper;
const MONITOR_PENDING_HEADING = exports.MONITOR_PENDING_HEADING = _i18n.i18n.translate('xpack.synthetics.monitorDetails.pending.heading', {
  defaultMessage: 'Initial test run pending...'
});
const MONITOR_PENDING_CONTENT = exports.MONITOR_PENDING_CONTENT = _i18n.i18n.translate('xpack.synthetics.monitorDetails.pending.content', {
  defaultMessage: 'This page will refresh when data becomes available.'
});
const LOADING_DESCRIPTION = exports.LOADING_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorDetails.loading.content', {
  defaultMessage: 'This will take just a second.'
});
const LOADING_TITLE = exports.LOADING_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorDetails.loading.heading', {
  defaultMessage: 'Loading monitor details'
});