"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorDetailsUrl = exports.ErrorsList = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _moment = _interopRequireDefault(require("moment"));
var _use_selected_location = require("../hooks/use_selected_location");
var _error_details_link = require("../../common/links/error_details_link");
var _use_error_failed_step = require("../hooks/use_error_failed_step");
var _test_time_formats = require("../../../utils/monitor_test_result/test_time_formats");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _use_monitor_latest_ping = require("../hooks/use_monitor_latest_ping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_errors/errors_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isErrorActive(lastError, currentError, latestPing) {
  return (latestPing === null || latestPing === void 0 ? void 0 : latestPing.monitor.status) === 'down' && lastError['@timestamp'] === currentError['@timestamp'] && typeof currentError['@timestamp'] !== undefined;
}
function getNextUpStateForResolvedError(errorState, upStates) {
  for (const upState of upStates) {
    if ((0, _moment.default)(upState.state.started_at).valueOf() > (0, _moment.default)(errorState['@timestamp']).valueOf()) return upState;
  }
}
const ErrorsList = ({
  errorStates,
  upStates,
  loading
}) => {
  var _errorStates$, _errorStates$sort;
  const {
    monitorId: configId
  } = (0, _reactRouterDom.useParams)();
  const checkGroups = (0, _react.useMemo)(() => {
    return errorStates.map(error => error.monitor.check_group);
  }, [errorStates]);
  const {
    failedSteps
  } = (0, _use_error_failed_step.useErrorFailedStep)(checkGroups);
  const isBrowserType = ((_errorStates$ = errorStates[0]) === null || _errorStates$ === void 0 ? void 0 : _errorStates$.monitor.type) === 'browser';
  const history = (0, _reactRouterDom.useHistory)();
  const formatter = (0, _use_date_format.useDateFormat)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    latestPing
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)({
    monitorId: configId
  });
  const lastErrorTestRun = errorStates === null || errorStates === void 0 ? void 0 : (_errorStates$sort = errorStates.sort((a, b) => {
    return (0, _moment.default)(b.state.started_at).valueOf() - (0, _moment.default)(a.state.started_at).valueOf();
  })) === null || _errorStates$sort === void 0 ? void 0 : _errorStates$sort[0];
  const isTabletOrGreater = (0, _eui.useIsWithinMinBreakpoint)('s');
  const columns = [{
    field: 'item.state.started_at',
    name: TIMESTAMP_LABEL,
    sortable: a => {
      return (0, _moment.default)(a.state.started_at).valueOf();
    },
    render: (_value, item) => {
      var _item$state;
      const link = /*#__PURE__*/_react.default.createElement(_error_details_link.ErrorDetailsLink, {
        configId: configId,
        stateId: (_item$state = item.state) === null || _item$state === void 0 ? void 0 : _item$state.id,
        label: formatter(item.state.started_at),
        locationId: selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      });
      if (isErrorActive(lastErrorTestRun, item, latestPing)) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center",
          wrap: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          className: "eui-textNoWrap",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 15
          }
        }, link), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          iconType: "clock",
          iconSide: "right",
          css: {
            maxWidth: 'max-content'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 17
          }
        }, ACTIVE_LABEL)));
      }
      return link;
    },
    mobileOptions: {
      header: false
    }
  }, ...(isBrowserType ? [{
    field: 'monitor.check_group',
    name: FAILED_STEP_LABEL,
    truncateText: true,
    sortable: a => {
      var _failedStep$synthetic, _failedStep$synthetic2;
      const failedStep = failedSteps.find(step => step.monitor.check_group === a.monitor.check_group);
      if (!failedStep) {
        return a.monitor.check_group;
      }
      return (_failedStep$synthetic = failedStep.synthetics) === null || _failedStep$synthetic === void 0 ? void 0 : (_failedStep$synthetic2 = _failedStep$synthetic.step) === null || _failedStep$synthetic2 === void 0 ? void 0 : _failedStep$synthetic2.name;
    },
    render: value => {
      var _failedStep$synthetic3, _failedStep$synthetic4, _failedStep$synthetic5, _failedStep$synthetic6;
      const failedStep = failedSteps.find(step => step.monitor.check_group === value);
      if (!failedStep) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "--");
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 17
        }
      }, (_failedStep$synthetic3 = failedStep.synthetics) === null || _failedStep$synthetic3 === void 0 ? void 0 : (_failedStep$synthetic4 = _failedStep$synthetic3.step) === null || _failedStep$synthetic4 === void 0 ? void 0 : _failedStep$synthetic4.index, ". ", (_failedStep$synthetic5 = failedStep.synthetics) === null || _failedStep$synthetic5 === void 0 ? void 0 : (_failedStep$synthetic6 = _failedStep$synthetic5.step) === null || _failedStep$synthetic6 === void 0 ? void 0 : _failedStep$synthetic6.name);
    }
  }] : []), {
    field: 'error.message',
    name: ERROR_MESSAGE_LABEL
  }, {
    field: 'state.duration_ms',
    name: ERROR_DURATION_LABEL,
    align: 'right',
    sortable: true,
    render: (value, item) => {
      let activeDuration = 0;
      if (item.monitor.timespan) {
        const diff = (0, _moment.default)(item.monitor.timespan.lt).diff((0, _moment.default)(item.monitor.timespan.gte), 'millisecond');
        if (isErrorActive(lastErrorTestRun, item, latestPing)) {
          const currentDiff = (0, _moment.default)().diff(item['@timestamp']);
          activeDuration = currentDiff < diff ? currentDiff : diff;
        } else {
          var _moment$diff;
          const resolvedState = getNextUpStateForResolvedError(item, upStates);
          activeDuration = (_moment$diff = (0, _moment.default)(resolvedState === null || resolvedState === void 0 ? void 0 : resolvedState.state.started_at).diff(item['@timestamp'])) !== null && _moment$diff !== void 0 ? _moment$diff : 0;
        }
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 11
        }
      }, (0, _test_time_formats.formatTestDuration)(Number(value) + activeDuration, true));
    }
  }];
  const getRowProps = item => {
    const {
      state
    } = item;
    if (state !== null && state !== void 0 && state.id) {
      return {
        'data-test-subj': `row-${state.id}`,
        onClick: evt => {
          history.push(`/monitor/${configId}/errors/${state.id}?locationId=${selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id}`);
        }
      };
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    css: {
      overflowX: isTabletOrGreater ? 'auto' : undefined
    },
    tableLayout: "auto",
    tableCaption: ERRORS_LIST_LABEL,
    loading: loading,
    items: errorStates,
    columns: columns,
    rowProps: getRowProps,
    pagination: {
      pageSizeOptions: [5, 10, 20, 50, 100]
    },
    sorting: {
      sort: {
        field: 'item.state.started_at',
        direction: 'desc'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }));
};
exports.ErrorsList = ErrorsList;
const getErrorDetailsUrl = ({
  basePath,
  configId,
  stateId,
  locationId
}) => {
  return `${basePath}/app/synthetics/monitor/${configId}/errors/${stateId}?locationId=${locationId}`;
};
exports.getErrorDetailsUrl = getErrorDetailsUrl;
const ERRORS_LIST_LABEL = _i18n.i18n.translate('xpack.synthetics.errorsList.label', {
  defaultMessage: 'Errors list'
});
const ERROR_DURATION_LABEL = _i18n.i18n.translate('xpack.synthetics.errorDuration.label', {
  defaultMessage: 'Error duration'
});
const ERROR_MESSAGE_LABEL = _i18n.i18n.translate('xpack.synthetics.errorMessage.label', {
  defaultMessage: 'Error message'
});
const FAILED_STEP_LABEL = _i18n.i18n.translate('xpack.synthetics.failedStep.label', {
  defaultMessage: 'Failed step'
});
const TIMESTAMP_LABEL = _i18n.i18n.translate('xpack.synthetics.timestamp.label', {
  defaultMessage: '@timestamp'
});
const ACTIVE_LABEL = _i18n.i18n.translate('xpack.synthetics.active.label', {
  defaultMessage: 'Active'
});