"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorEditPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _can_use_public_locations_callout = require("./steps/can_use_public_locations_callout");
var _disabled_callout = require("../monitors_page/management/disabled_callout");
var _use_capabilities = require("../../../../hooks/use_capabilities");
var _edit_monitor_not_found = require("./edit_monitor_not_found");
var _monitor_detail_flyout = require("../monitors_page/overview/overview/monitor_detail_flyout");
var _runtime_types = require("../../../../../common/runtime_types");
var _state = require("../../state");
var _alerting_callout = require("../common/alerting_callout/alerting_callout");
var _steps = require("./steps");
var _form = require("./form");
var _locations_loading_error = require("./locations_loading_error");
var _monitor_details_portal = require("./monitor_details_portal");
var _use_breadcrumbs = require("./use_breadcrumbs");
var _step_config = require("./steps/step_config");
var _use_monitor_not_found = require("./hooks/use_monitor_not_found");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/monitor_edit_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorEditPage = () => {
  var _data$ConfigKey$ALERT, _data$ConfigKey$ALERT2;
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'edit-monitor'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'edit-monitor',
    delay: 15000
  });
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const {
    spaceId
  } = (0, _hooks.useGetUrlParams)();
  (0, _use_breadcrumbs.useMonitorAddEditBreadcrumbs)(true);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    locationsLoaded,
    error: locationsError
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  (0, _react.useEffect)(() => {
    if (!locationsLoaded) {
      dispatch((0, _state.getServiceLocations)());
    }
  }, [locationsLoaded, dispatch]);
  const data = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitor);
  const isLoading = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitorLoading);
  const error = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitorError);
  (0, _react.useEffect)(() => {
    dispatch(_state.getMonitorAction.get({
      monitorId,
      spaceId
    }));
  }, [dispatch, monitorId, spaceId]);
  const monitorNotFoundError = (0, _use_monitor_not_found.useMonitorNotFound)(error, data === null || data === void 0 ? void 0 : data.id);
  const canUsePublicLocations = (0, _use_capabilities.useCanUsePublicLocations)(data === null || data === void 0 ? void 0 : data[_runtime_types.ConfigKey.LOCATIONS]);
  if (monitorNotFoundError) {
    return /*#__PURE__*/_react.default.createElement(_edit_monitor_not_found.EditMonitorNotFound, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 12
      }
    });
  }
  const isReadOnly = (data === null || data === void 0 ? void 0 : data[_runtime_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _runtime_types.SourceType.PROJECT || !canUsePublicLocations;
  const projectId = data === null || data === void 0 ? void 0 : data[_runtime_types.ConfigKey.PROJECT_ID];
  if (locationsError) {
    return /*#__PURE__*/_react.default.createElement(_locations_loading_error.LocationsLoadingError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 12
      }
    });
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorEditPage.error.label', {
        defaultMessage: 'Unable to load monitor configuration'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.synthetics.monitorEditPage.error.content', {
        defaultMessage: 'There was an error loading your monitor. Please try again later.'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    });
  }
  return data && locationsLoaded && !isLoading && !error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_can_use_public_locations_callout.CanUsePublicLocationsCallout, {
    canUsePublicLocations: canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_alerting_callout.AlertingCallout, {
    isAlertingEnabled: (_data$ConfigKey$ALERT = data[_runtime_types.ConfigKey.ALERT_CONFIG]) === null || _data$ConfigKey$ALERT === void 0 ? void 0 : (_data$ConfigKey$ALERT2 = _data$ConfigKey$ALERT.status) === null || _data$ConfigKey$ALERT2 === void 0 ? void 0 : _data$ConfigKey$ALERT2.enabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_form.MonitorForm, {
    defaultValues: data,
    readOnly: isReadOnly,
    canUsePublicLocations: canUsePublicLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_steps.MonitorSteps, {
    stepMap: (0, _step_config.EDIT_MONITOR_STEPS)(isReadOnly),
    isEditFlow: true,
    readOnly: isReadOnly,
    projectId: projectId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_details_portal.MonitorDetailsLinkPortal, {
    configId: data === null || data === void 0 ? void 0 : data[_runtime_types.ConfigKey.CONFIG_ID],
    name: data === null || data === void 0 ? void 0 : data.name,
    updateUrl: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  });
};
exports.MonitorEditPage = MonitorEditPage;