"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrottlingConfigField = exports.PROFILE_OPTIONS = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _use_connection_profiles = require("./use_connection_profiles");
var _throttling_disabled_callout = require("./throttling_disabled_callout");
var _throttling_fields = require("./throttling_fields");
var _constants = require("../../constants");
var _connection_profile = require("./connection_profile");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/throttling/throttling_config_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ThrottlingConfigField = props => {
  const {
    value,
    initialValue
  } = props;
  const isCustom = _constants.PROFILES_MAP[value === null || value === void 0 ? void 0 : value.id] === undefined;
  const isThrottlingDisabled = (value === null || value === void 0 ? void 0 : value.id) === _constants.PROFILE_VALUES_ENUM.NO_THROTTLING;
  const options = (0, _use_connection_profiles.useConnectionProfiles)(initialValue);
  const isThrottlingEnabled = (0, _public.useUiSetting)(_public2.syntheticsThrottlingEnabled);
  const isReadOnly = props.readOnly || !isThrottlingEnabled;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "syntheticsThrottlingSelect",
    options: options,
    onChange: newValue => {
      if (newValue === _constants.PROFILE_VALUES_ENUM.CUSTOM) {
        props.onChange({
          ..._constants.PROFILES_MAP[_constants.PROFILE_VALUES_ENUM.DEFAULT],
          id: _constants.PROFILE_VALUES_ENUM.CUSTOM,
          label: _constants.CUSTOM_LABEL
        });
      } else {
        props.onChange({
          ..._constants.PROFILES_MAP[_constants.PROFILE_VALUES_ENUM.DEFAULT],
          ..._constants.PROFILES_MAP[newValue]
        });
      }
    },
    defaultValue: _constants.PROFILE_VALUES_ENUM.DEFAULT,
    valueOfSelected: value === null || value === void 0 ? void 0 : value.id,
    fullWidth: props.fullWidth,
    readOnly: isReadOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), isThrottlingDisabled && /*#__PURE__*/_react.default.createElement(_throttling_disabled_callout.ThrottlingDisabledCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 32
    }
  }), isCustom && /*#__PURE__*/_react.default.createElement(_throttling_fields.ThrottlingFields, {
    throttling: props === null || props === void 0 ? void 0 : props.value,
    setValue: props.onChange,
    readOnly: isReadOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }));
};
exports.ThrottlingConfigField = ThrottlingConfigField;
const PROFILE_OPTIONS = exports.PROFILE_OPTIONS = _constants.PROFILE_VALUES.map(({
  id
}) => ({
  value: id,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_connection_profile.ConnectionProfile, {
    throttling: _constants.PROFILES_MAP[id],
    id: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }),
  'data-test-subj': `syntheticsThrottlingSelect-${id}`
}));