"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowsLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/fields/maintenance_windows/create_maintenance_windows_btn.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MaintenanceWindowsLink = ({
  id,
  label
}) => {
  const {
    http
  } = (0, _public.useKibana)().services;
  if (!id) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      external: true,
      "data-test-subj": "syntheticsCreateMaintenanceWindowsBtnButton",
      href: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/insightsAndAlerting/maintenanceWindows/create'),
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 17,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.synthetics.monitorConfig.maintenanceWindows.createButton', {
      defaultMessage: 'Create'
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      external: true,
      "data-test-subj": "syntheticsEditMaintenanceWindowsBtnButton",
      href: http === null || http === void 0 ? void 0 : http.basePath.prepend(`/app/management/insightsAndAlerting/maintenanceWindows/edit/${id}`),
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    }, label);
  }
};
exports.MaintenanceWindowsLink = MaintenanceWindowsLink;