"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedConfig = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _form_config = require("../form/form_config");
var _field = require("../form/field");
var _types = require("../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_add_edit/advanced/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdvancedConfig = ({
  readOnly
}) => {
  var _formConfig$advanced;
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const [type] = watch([_types.ConfigKey.FORM_MONITOR_TYPE]);
  const formConfig = (0, _react.useMemo)(() => {
    return (0, _form_config.FORM_CONFIG)(readOnly)[type];
  }, [readOnly, type]);
  return formConfig !== null && formConfig !== void 0 && formConfig.advanced ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "syntheticsAdvancedPanel",
    buttonContent: _i18n.i18n.translate('xpack.synthetics.monitorConfig.advancedOptions.title', {
      defaultMessage: 'Advanced options'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }), (_formConfig$advanced = formConfig.advanced) === null || _formConfig$advanced === void 0 ? void 0 : _formConfig$advanced.map(configGroup => {
    return /*#__PURE__*/_react.default.createElement(DescribedFormGroup, {
      description: configGroup.description,
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 22
        }
      }, configGroup.title),
      fullWidth: true,
      key: configGroup.title,
      descriptionFlexItemProps: {
        style: {
          minWidth: 208
        }
      },
      fieldFlexItemProps: {
        style: {
          minWidth: 208
        }
      },
      style: {
        flexWrap: 'wrap'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 13
      }
    }, configGroup.components.map(field => {
      return /*#__PURE__*/_react.default.createElement(_field.Field, (0, _extends2.default)({}, field, {
        key: field.fieldKey,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 24
        }
      }));
    }));
  }))) : null;
};
exports.AdvancedConfig = AdvancedConfig;
const DescribedFormGroup = (0, _styledComponents.default)(_eui.EuiDescribedFormGroup)`
  > div.euiFlexGroup {
    flex-wrap: wrap;
  }
`;