"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolvedAt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_date_format = require("../../../../../hooks/use_date_format");
var _use_find_my_killer_state = require("../hooks/use_find_my_killer_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/error_details/components/resolved_at.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ResolvedAt = () => {
  var _killerState$Timesta;
  const {
    killerState
  } = (0, _use_find_my_killer_state.useFindMyKillerState)();
  const formatter = (0, _use_date_format.useDateFormat)();
  let endsAt = formatter((_killerState$Timesta = killerState === null || killerState === void 0 ? void 0 : killerState['@timestamp']) !== null && _killerState$Timesta !== void 0 ? _killerState$Timesta : '');
  if (!endsAt) {
    endsAt = 'N/A';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: ERROR_DURATION,
      description: endsAt
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 10
    }
  });
};
exports.ResolvedAt = ResolvedAt;
const ERROR_DURATION = _i18n.i18n.translate('xpack.synthetics.errorDetails.resolvedAt', {
  defaultMessage: 'Resolved at'
});