"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorTimeline = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _failed_tests = require("../../monitor_details/monitor_errors/failed_tests");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/error_details/components/error_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ErrorTimeline = ({
  lastTestRun
}) => {
  var _lastTestRun$monitor$, _lastTestRun$monitor$2, _lastTestRun$state;
  if (!lastTestRun) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 15,
        columnNumber: 12
      }
    });
  }
  const diff = (0, _moment.default)((_lastTestRun$monitor$ = lastTestRun.monitor.timespan) === null || _lastTestRun$monitor$ === void 0 ? void 0 : _lastTestRun$monitor$.lt).diff((0, _moment.default)((_lastTestRun$monitor$2 = lastTestRun.monitor.timespan) === null || _lastTestRun$monitor$2 === void 0 ? void 0 : _lastTestRun$monitor$2.gte), 'minutes');
  const startedAt = lastTestRun === null || lastTestRun === void 0 ? void 0 : (_lastTestRun$state = lastTestRun.state) === null || _lastTestRun$state === void 0 ? void 0 : _lastTestRun$state.started_at;
  return /*#__PURE__*/_react.default.createElement(_failed_tests.MonitorFailedTests, {
    time: {
      from: (0, _moment.default)(startedAt).subtract(diff / 2, 'minutes').toISOString(),
      to: (0, _moment.default)(lastTestRun['@timestamp']).add(diff / 2, 'minutes').toISOString()
    },
    allowBrushing: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
};
exports.ErrorTimeline = ErrorTimeline;