"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorsMWsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRedux = require("react-redux");
var _mws_callout_content = require("./mws_callout_content");
var _overview_status = require("../../../state/overview_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/mws_callout/monitors_mws_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorsMWsCallout = () => {
  const {
    allConfigs
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const services = (0, _public.useKibana)().services;
  const {
    data
  } = (0, _alertsUiShared.useFetchActiveMaintenanceWindows)(services, {
    enabled: true
  });
  const monitorMWs = new Set(allConfigs === null || allConfigs === void 0 ? void 0 : allConfigs.flatMap(config => {
    var _config$maintenanceWi;
    return (_config$maintenanceWi = config.maintenanceWindows) !== null && _config$maintenanceWi !== void 0 ? _config$maintenanceWi : [];
  }));
  const hasMonitorMWs = monitorMWs && monitorMWs.size > 0;
  if (data !== null && data !== void 0 && data.length && hasMonitorMWs) {
    const activeMWs = data.filter(mw => monitorMWs.has(mw.id));
    if (activeMWs.length) {
      return /*#__PURE__*/_react.default.createElement(_mws_callout_content.MwsCalloutContent, {
        activeMWs: activeMWs,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 14
        }
      });
    }
  }
  return null;
};
exports.MonitorsMWsCallout = MonitorsMWsCallout;