"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorHeaderLink = InspectorHeaderLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _contexts = require("../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/header/inspector_header_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function InspectorHeaderLink() {
  const {
    services: {
      inspector,
      uiSettings
    }
  } = (0, _public.useKibana)();
  const {
    isDev
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const {
    inspectorAdapters
  } = (0, _public3.useInspectorContext)();
  const isInspectorEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_public2.enableInspectEsQueries);
  const inspect = () => {
    inspector.open(inspectorAdapters);
  };
  if (!isInspectorEnabled && !isDev) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    onClick: inspect,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.synthetics.inspectButtonText', {
    defaultMessage: 'Inspect'
  }));
}