"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToDashboard = exports.AddToDashboard = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/presentation-util-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactRedux = require("react-redux");
var _constants = require("../../../../embeddables/constants");
var _state = require("../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/add_to_dashboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
const useAddToDashboard = ({
  type,
  embeddableInput = {},
  objectType = _i18n.i18n.translate('xpack.synthetics.item.actions.addToDashboard.objectTypeLabel', {
    defaultMessage: 'Status Overview'
  }),
  documentTitle = _i18n.i18n.translate('xpack.synthetics.item.actions.addToDashboard.attachmentTitle', {
    defaultMessage: 'Status Overview'
  })
}) => {
  const [isDashboardAttachmentReady, setDashboardAttachmentReady] = _react.default.useState(false);
  const {
    embeddable
  } = (0, _public2.useKibana)().services;
  const handleAttachToDashboardSave = (0, _react.useCallback)(async ({
    dashboardId
  }) => {
    const stateTransfer = embeddable.getStateTransfer();
    const state = {
      serializedState: {
        rawState: embeddableInput
      },
      type
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [embeddable, type, embeddableInput]);
  const MaybeSavedObjectSaveModalDashboard = isDashboardAttachmentReady ? /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboard, {
    objectType: objectType,
    documentInfo: {
      title: documentTitle
    },
    canSaveByReference: false,
    onClose: () => {
      setDashboardAttachmentReady(false);
    },
    onSave: handleAttachToDashboardSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }) : null;
  return {
    setDashboardAttachmentReady,
    MaybeSavedObjectSaveModalDashboard
  };
};
exports.useAddToDashboard = useAddToDashboard;
const AddToDashboard = ({
  type,
  isLoading,
  asButton = false
}) => {
  const {
    view
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const {
    setDashboardAttachmentReady,
    MaybeSavedObjectSaveModalDashboard
  } = useAddToDashboard(type === _constants.SYNTHETICS_STATS_OVERVIEW_EMBEDDABLE ? {
    type
  } : {
    type,
    embeddableInput: {
      view
    }
  });
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const isSyntheticsApp = window.location.pathname.includes('/app/synthetics');
  if (!isSyntheticsApp) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, asButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "primary",
    "data-test-subj": "syntheticsEmbeddablePanelWrapperButton",
    iconType: "dashboardApp",
    onClick: () => setDashboardAttachmentReady(true),
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.synthetics.embeddablePanelWrapper.shareButtonLabel', {
    defaultMessage: 'Add to dashboard'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      "data-test-subj": "syntheticsEmbeddablePanelWrapperButton",
      iconType: "boxesHorizontal",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "aria-label": _i18n.i18n.translate('xpack.synthetics.embeddablePanelWrapper.shareButtonAriaLabel', {
        defaultMessage: 'Add to dashboard'
      }),
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "share",
      icon: "dashboardApp",
      onClick: () => {
        setDashboardAttachmentReady(true);
        closePopover();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.synthetics.embeddablePanelWrapper.shareContextMenuItemLabel', {
      defaultMessage: 'Add to dashboard'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  })), MaybeSavedObjectSaveModalDashboard);
};
exports.AddToDashboard = AddToDashboard;