"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WITHIN_TOTAL_CHECKS_LABEL = exports.WITHIN_TOTAL_CHECKS_EXPRESSION = exports.WITHIN_TIMERANGE_LABEL = exports.WITHIN_TIMERANGE_EXPRESSION = exports.ForTheLastExpression = exports.DEFAULT_CONDITION = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _status_rule = require("../../../../../../common/rules/status_rule");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/common/for_the_last_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WITHIN_TOTAL_CHECKS_LABEL = exports.WITHIN_TOTAL_CHECKS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatusRule.withinTotalChecks.label', {
  defaultMessage: 'Within total checks'
});
const WITHIN_TOTAL_CHECKS_EXPRESSION = exports.WITHIN_TOTAL_CHECKS_EXPRESSION = _i18n.i18n.translate('xpack.synthetics.monitorStatusRule.withinTotalChecks.expression', {
  defaultMessage: 'Within the last'
});
const WITHIN_TIMERANGE_EXPRESSION = exports.WITHIN_TIMERANGE_EXPRESSION = _i18n.i18n.translate('xpack.synthetics.monitorStatusRule.withinTimerange.expression', {
  defaultMessage: 'Within the last'
});
const WITHIN_TIMERANGE_LABEL = exports.WITHIN_TIMERANGE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorStatusRule.withinTimerange.label', {
  defaultMessage: 'Within timerange'
});
const OPTIONS = [{
  label: WITHIN_TOTAL_CHECKS_LABEL,
  key: 'checksWindow'
}, {
  label: WITHIN_TIMERANGE_LABEL,
  key: 'timeWindow'
}];
const DEFAULT_CONDITION = exports.DEFAULT_CONDITION = {
  window: {
    numberOfChecks: 5
  },
  groupBy: 'locationId',
  downThreshold: 3,
  locationsThreshold: 1,
  recoveryStrategy: 'firstUp'
};
const getCheckedOption = (option, condition) => {
  const {
    useTimeWindow,
    isLocationBased
  } = (0, _status_rule.getConditionType)(condition);
  if (isLocationBased && option.key === 'locations') {
    return 'on';
  }
  if (option.key === 'timeWindow' && useTimeWindow && !isLocationBased) {
    return 'on';
  }
  if (option.key === 'checksWindow' && !useTimeWindow && !isLocationBased) {
    return 'on';
  }
  return undefined;
};
const ForTheLastExpression = ({
  ruleParams,
  setRuleParams
}) => {
  const {
    condition
  } = ruleParams;
  const {
    useTimeWindow
  } = (0, _status_rule.getConditionType)(condition);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [options, setOptions] = (0, _react.useState)(OPTIONS);
  (0, _react.useEffect)(() => {
    if (!condition) {
      setRuleParams('condition', DEFAULT_CONDITION);
    }
  }, [condition, setRuleParams]);
  (0, _react.useEffect)(() => {
    setOptions(OPTIONS.map(option => ({
      key: option.key,
      label: option.label,
      checked: getCheckedOption(option, condition)
    })));
  }, [condition, useTimeWindow]);
  const getDescriptiveText = () => {
    if (useTimeWindow) {
      return WITHIN_TIMERANGE_EXPRESSION;
    }
    return WITHIN_TOTAL_CHECKS_EXPRESSION;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "checkPopover",
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: getDescriptiveText(),
      isActive: isOpen,
      onClick: () => setIsOpen(!isOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    }),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: "always",
    options: options,
    onChange: selectedValues => {
      var _selectedValues$filte;
      const selectedValue = (_selectedValues$filte = selectedValues.filter(v => v.checked === 'on')) === null || _selectedValues$filte === void 0 ? void 0 : _selectedValues$filte[0];
      switch (selectedValue === null || selectedValue === void 0 ? void 0 : selectedValue.key) {
        case 'checksWindow':
          setRuleParams('condition', {
            ...ruleParams.condition,
            window: {
              numberOfChecks: 5
            }
          });
          break;
        case 'timeWindow':
          setRuleParams('condition', {
            ...ruleParams.condition,
            window: {
              time: {
                unit: 'm',
                size: 5
              }
            }
          });
          break;
        default:
          break;
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 240
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.synthetics.forTheLastExpression.whenPopoverTitleLabel', {
    defaultMessage: 'When'
  })), list)));
};
exports.ForTheLastExpression = ForTheLastExpression;