"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPopoverExpression = FieldPopoverExpression;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sloSchema = require("@kbn/slo-schema");
var _lodash = require("lodash");
var _fields = require("./fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/common/field_popover_expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FieldPopoverExpression({
  title,
  value,
  children,
  color,
  selectedField,
  fieldName,
  setSelectedField,
  allSuggestions
}) {
  var _suggestions$filter;
  const isPopoverOpen = selectedField === fieldName;
  const suggestions = allSuggestions === null || allSuggestions === void 0 ? void 0 : allSuggestions[fieldName];
  let label = !(0, _lodash.isEmpty)(value) && value ? suggestions === null || suggestions === void 0 ? void 0 : (_suggestions$filter = suggestions.filter(suggestion => value.includes(suggestion.value))) === null || _suggestions$filter === void 0 ? void 0 : _suggestions$filter.map(suggestion => suggestion.label).join(', ') : _fields.allOptionText;
  if (value !== null && value !== void 0 && value.includes(_sloSchema.ALL_VALUE)) {
    label = _fields.allOptionText;
  }
  const closePopover = () => setSelectedField(selectedField === fieldName ? undefined : fieldName);
  return /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    anchorPosition: "downLeft",
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: title,
      value: label,
      isActive: Boolean(selectedField),
      color: color,
      onClick: closePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }),
    repositionOnScroll: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, children)));
}