"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitorLocationNavigatorParams = void 0;
var _common = require("@kbn/observability-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function navigate({
  locationId
}) {
  const locations = encodeURIComponent(JSON.stringify([locationId]));
  return {
    app: 'synthetics',
    path: `?locations=${[locations]}`,
    state: {}
  };
}
const monitorLocationNavigatorParams = exports.monitorLocationNavigatorParams = {
  id: _common.syntheticsMonitorLocationQueryLocatorID,
  getLocation: navigate
};