"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatsOverviewStore = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _reduxSaga = _interopRequireDefault(require("redux-saga"));
var _root_reducer = require("../../synthetics/state/root_reducer");
var _root_effect = require("../../synthetics/state/root_effect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStatsOverviewStore = () => {
  const sagaMW = (0, _reduxSaga.default)();
  const store = (0, _toolkit.configureStore)({
    reducer: _root_reducer.rootReducer,
    middleware: getDefaultMiddleware => getDefaultMiddleware({
      thunk: false
    }).concat(sagaMW),
    devTools: process.env.NODE_ENV !== 'production',
    preloadedState: {},
    enhancers: []
  });
  sagaMW.run(_root_effect.rootEffect);
  return store;
};
exports.getStatsOverviewStore = getStatsOverviewStore;