"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openMonitorConfiguration = openMonitorConfiguration;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@kbn/react-query");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-react-plugin/public");
var _monitor_configuration = require("./monitor_configuration");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/embeddables/common/monitors_open_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Function overloads to provide type safety without casting

// Implementation
async function openMonitorConfiguration({
  coreStart,
  pluginStart,
  initialState,
  title,
  type
}) {
  const {
    overlays
  } = coreStart;
  const queryClient = new _reactQuery.QueryClient();
  return new Promise(async (resolve, reject) => {
    try {
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          ...pluginStart
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
        client: queryClient,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_monitor_configuration.MonitorConfiguration, {
        title: title,
        initialInput: initialState,
        onCreate: update => {
          flyoutSession.close();
          resolve(update);
        },
        onCancel: () => {
          flyoutSession.close();
          reject();
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 15
        }
      }, type === _constants.SYNTHETICS_MONITORS_EMBEDDABLE ? /*#__PURE__*/_react.default.createElement(_monitor_configuration.MonitorConfiguration.ViewSwitch, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 19
        }
      }) : null))), coreStart));
    } catch (error) {
      reject(error);
    }
  });
}