"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.joinValidation = joinValidation;
exports.modelValidation = modelValidation;
var _lodash = require("lodash");
var _zod = require("@kbn/zod");
var _validation = require("./validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// need explicit keys here to be able to generate Assert types (TS2775)

function joinValidation(left, rights) {
  function join(key) {
    return (0, _validation.validation)(left[key].right, _zod.z.union(rights.map(right => right[key].right)));
  }
  return {
    Definition: join('Definition'),
    GetResponse: join('GetResponse'),
    Source: join('Source'),
    UpsertRequest: join('UpsertRequest')
  };
}
function modelValidation(...args) {
  if (args.length === 1) {
    const right = args[0];
    return modelValidation({
      Definition: (0, _validation.validation)(_zod.z.any(), _zod.z.object({})),
      Source: (0, _validation.validation)(_zod.z.any(), _zod.z.object({})),
      GetResponse: (0, _validation.validation)(_zod.z.any(), _zod.z.object({})),
      UpsertRequest: (0, _validation.validation)(_zod.z.any(), _zod.z.object({}))
    }, right);
  }
  const left = (0, _lodash.mapValues)(args[0], value => value.right);
  const rightPartial = args[1];
  const right = {
    Definition: _zod.z.intersection(left.Definition, rightPartial.Definition),
    Source: _zod.z.intersection(left.Source, _zod.z.intersection(rightPartial.Definition, rightPartial.Source)),
    GetResponse: _zod.z.intersection(left.GetResponse, _zod.z.intersection(_zod.z.object({
      stream: rightPartial.Definition
    }), rightPartial.GetResponse)),
    UpsertRequest: _zod.z.intersection(left.UpsertRequest, _zod.z.intersection(_zod.z.object({
      // upsert doesn't allow name to be set
      stream: _zod.z.object({
        name: _zod.z.undefined().optional()
      }).passthrough()
      // but the definition requires it, so we set a default
      .transform(prev => ({
        ...prev,
        name: '.'
      })).pipe(rightPartial.Definition)
      // that should be removed after
      .transform(prev => {
        delete prev.name;
        return prev;
      })
    }), rightPartial.UpsertRequest))
  };
  return {
    Definition: (0, _validation.validation)(left.Definition, right.Definition),
    Source: (0, _validation.validation)(left.Source, right.Source),
    GetResponse: (0, _validation.validation)(left.GetResponse, right.GetResponse),
    UpsertRequest: (0, _validation.validation)(left.UpsertRequest, right.UpsertRequest)
  };
}